/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.Verified: ImageVector
    get() {
        if (_verified != null) {
            return _verified!!
        }
        _verified = materialIcon(name = "TwoTone.Verified") {
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(18.49f, 9.88f)
                lineToRelative(0.08f, -0.85f)
                lineToRelative(0.18f, -1.95f)
                lineToRelative(-1.9f, -0.43f)
                lineToRelative(-0.84f, -0.19f)
                lineToRelative(-0.44f, -0.74f)
                lineToRelative(-0.99f, -1.68f)
                lineTo(12.79f, 4.8f)
                lineTo(12.0f, 5.14f)
                lineTo(11.21f, 4.8f)
                lineTo(9.42f, 4.03f)
                lineTo(8.43f, 5.71f)
                lineTo(7.99f, 6.45f)
                lineTo(7.15f, 6.64f)
                lineToRelative(-1.9f, 0.43f)
                lineToRelative(0.18f, 1.94f)
                lineToRelative(0.08f, 0.85f)
                lineToRelative(-0.56f, 0.65f)
                lineToRelative(-1.29f, 1.48f)
                lineToRelative(1.29f, 1.47f)
                lineToRelative(0.56f, 0.65f)
                lineToRelative(-0.08f, 0.85f)
                lineToRelative(-0.18f, 1.96f)
                lineToRelative(1.9f, 0.43f)
                lineToRelative(0.84f, 0.19f)
                lineToRelative(0.44f, 0.74f)
                lineToRelative(0.99f, 1.67f)
                lineToRelative(1.78f, -0.77f)
                lineTo(12.0f, 18.85f)
                lineToRelative(0.79f, 0.34f)
                lineToRelative(1.78f, 0.77f)
                lineToRelative(0.99f, -1.68f)
                lineToRelative(0.44f, -0.74f)
                lineToRelative(0.84f, -0.19f)
                lineToRelative(1.9f, -0.43f)
                lineToRelative(-0.18f, -1.95f)
                lineToRelative(-0.08f, -0.85f)
                lineToRelative(0.56f, -0.65f)
                lineToRelative(1.29f, -1.47f)
                lineToRelative(-1.29f, -1.47f)
                lineTo(18.49f, 9.88f)
                close()
                moveTo(10.09f, 16.72f)
                lineToRelative(-3.8f, -3.81f)
                lineToRelative(1.48f, -1.48f)
                lineToRelative(2.32f, 2.33f)
                lineToRelative(5.85f, -5.87f)
                lineToRelative(1.48f, 1.48f)
                lineTo(10.09f, 16.72f)
                close()
            }
            materialPath {
                moveTo(23.0f, 11.99f)
                lineToRelative(-2.44f, -2.79f)
                lineToRelative(0.34f, -3.69f)
                lineToRelative(-3.61f, -0.82f)
                lineTo(15.4f, 1.5f)
                lineTo(12.0f, 2.96f)
                lineTo(8.6f, 1.5f)
                lineTo(6.71f, 4.69f)
                lineTo(3.1f, 5.5f)
                lineTo(3.44f, 9.2f)
                lineTo(1.0f, 11.99f)
                lineToRelative(2.44f, 2.79f)
                lineToRelative(-0.34f, 3.7f)
                lineToRelative(3.61f, 0.82f)
                lineTo(8.6f, 22.5f)
                lineToRelative(3.4f, -1.47f)
                lineToRelative(3.4f, 1.46f)
                lineToRelative(1.89f, -3.19f)
                lineToRelative(3.61f, -0.82f)
                lineToRelative(-0.34f, -3.69f)
                lineTo(23.0f, 11.99f)
                close()
                moveTo(19.05f, 13.47f)
                lineToRelative(-0.56f, 0.65f)
                lineToRelative(0.08f, 0.85f)
                lineToRelative(0.18f, 1.95f)
                lineToRelative(-1.9f, 0.43f)
                lineToRelative(-0.84f, 0.19f)
                lineToRelative(-0.44f, 0.74f)
                lineToRelative(-0.99f, 1.68f)
                lineToRelative(-1.78f, -0.77f)
                lineTo(12.0f, 18.85f)
                lineToRelative(-0.79f, 0.34f)
                lineToRelative(-1.78f, 0.77f)
                lineToRelative(-0.99f, -1.67f)
                lineToRelative(-0.44f, -0.74f)
                lineToRelative(-0.84f, -0.19f)
                lineToRelative(-1.9f, -0.43f)
                lineToRelative(0.18f, -1.96f)
                lineToRelative(0.08f, -0.85f)
                lineToRelative(-0.56f, -0.65f)
                lineToRelative(-1.29f, -1.47f)
                lineToRelative(1.29f, -1.48f)
                lineToRelative(0.56f, -0.65f)
                lineTo(5.43f, 9.01f)
                lineTo(5.25f, 7.07f)
                lineToRelative(1.9f, -0.43f)
                lineToRelative(0.84f, -0.19f)
                lineToRelative(0.44f, -0.74f)
                lineToRelative(0.99f, -1.68f)
                lineToRelative(1.78f, 0.77f)
                lineTo(12.0f, 5.14f)
                lineToRelative(0.79f, -0.34f)
                lineToRelative(1.78f, -0.77f)
                lineToRelative(0.99f, 1.68f)
                lineToRelative(0.44f, 0.74f)
                lineToRelative(0.84f, 0.19f)
                lineToRelative(1.9f, 0.43f)
                lineToRelative(-0.18f, 1.95f)
                lineToRelative(-0.08f, 0.85f)
                lineToRelative(0.56f, 0.65f)
                lineToRelative(1.29f, 1.47f)
                lineTo(19.05f, 13.47f)
                close()
            }
            materialPath {
                moveTo(10.09f, 13.75f)
                lineToRelative(-2.32f, -2.33f)
                lineToRelative(-1.48f, 1.49f)
                lineToRelative(3.8f, 3.81f)
                lineToRelative(7.34f, -7.36f)
                lineToRelative(-1.48f, -1.49f)
                close()
            }
        }
        return _verified!!
    }

private var _verified: ImageVector? = null
