/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.automirrored.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.AutoMirrored.Sharp.NextPlan: ImageVector
    get() {
        if (_nextPlan != null) {
            return _nextPlan!!
        }
        _nextPlan = materialIcon(name = "AutoMirrored.Sharp.NextPlan", autoMirror = true) {
            materialPath {
                moveTo(12.0f, 2.0f)
                curveTo(6.48f, 2.0f, 2.0f, 6.48f, 2.0f, 12.0f)
                curveToRelative(0.0f, 5.52f, 4.48f, 10.0f, 10.0f, 10.0f)
                reflectiveCurveToRelative(10.0f, -4.48f, 10.0f, -10.0f)
                curveTo(22.0f, 6.48f, 17.52f, 2.0f, 12.0f, 2.0f)
                close()
                moveTo(18.0f, 13.97f)
                horizontalLineToRelative(-5.0f)
                lineToRelative(2.26f, -2.26f)
                curveToRelative(-0.91f, -1.06f, -2.25f, -1.74f, -3.76f, -1.74f)
                curveToRelative(-2.37f, 0.0f, -4.35f, 1.66f, -4.86f, 3.88f)
                lineToRelative(-0.96f, -0.32f)
                curveToRelative(0.64f, -2.62f, 3.0f, -4.56f, 5.82f, -4.56f)
                curveToRelative(1.78f, 0.0f, 3.37f, 0.79f, 4.47f, 2.03f)
                lineTo(18.0f, 8.97f)
                verticalLineTo(13.97f)
                close()
            }
        }
        return _nextPlan!!
    }

private var _nextPlan: ImageVector? = null
