/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.automirrored.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.AutoMirrored.TwoTone.NotListedLocation: ImageVector
    get() {
        if (_notListedLocation != null) {
            return _notListedLocation!!
        }
        _notListedLocation = materialIcon(name = "AutoMirrored.TwoTone.NotListedLocation",
                autoMirror = true) {
            materialPath(fillAlpha = 0.3f) {
                moveTo(18.5f, 10.2f)
                curveToRelative(0.0f, 2.57f, -2.1f, 5.79f, -6.16f, 9.51f)
                lineTo(12.0f, 20.01f)
                lineToRelative(-0.34f, -0.31f)
                curveTo(7.6f, 15.99f, 5.5f, 12.77f, 5.5f, 10.2f)
                curveToRelative(0.0f, -3.84f, 2.82f, -6.7f, 6.5f, -6.7f)
                reflectiveCurveTo(18.5f, 6.35f, 18.5f, 10.2f)
                close()
            }
            materialPath {
                moveTo(12.01f, 16.0f)
                curveToRelative(-0.27f, 0.0f, -0.52f, -0.1f, -0.71f, -0.29f)
                curveToRelative(-0.2f, -0.2f, -0.29f, -0.43f, -0.29f, -0.71f)
                curveToRelative(-0.01f, -0.55f, 0.43f, -0.99f, 0.98f, -1.0f)
                curveToRelative(0.01f, 0.0f, 0.01f, 0.0f, 0.02f, 0.0f)
                curveToRelative(0.28f, 0.0f, 0.51f, 0.1f, 0.71f, 0.29f)
                curveToRelative(0.18f, 0.19f, 0.28f, 0.43f, 0.28f, 0.7f)
                reflectiveCurveToRelative(-0.1f, 0.51f, -0.29f, 0.71f)
                reflectiveCurveTo(12.28f, 16.0f, 12.01f, 16.0f)
                close()
                moveTo(11.13f, 12.34f)
                curveToRelative(0.0f, -0.45f, 0.1f, -0.84f, 0.29f, -1.16f)
                curveToRelative(0.19f, -0.33f, 0.53f, -0.7f, 1.0f, -1.12f)
                curveToRelative(0.28f, -0.25f, 0.48f, -0.47f, 0.61f, -0.66f)
                reflectiveCurveToRelative(0.19f, -0.4f, 0.19f, -0.64f)
                curveToRelative(0.0f, -0.29f, -0.11f, -0.53f, -0.32f, -0.74f)
                curveToRelative(-0.21f, -0.2f, -0.5f, -0.3f, -0.85f, -0.3f)
                curveToRelative(-0.37f, 0.0f, -0.74f, 0.1f, -0.96f, 0.3f)
                curveToRelative(-0.21f, 0.2f, -0.4f, 0.45f, -0.4f, 0.98f)
                horizontalLineTo(9.0f)
                curveToRelative(0.0f, -1.01f, 0.46f, -1.73f, 0.97f, -2.21f)
                curveTo(10.53f, 6.28f, 11.25f, 6.0f, 12.0f, 6.0f)
                curveToRelative(0.59f, 0.0f, 1.11f, 0.12f, 1.57f, 0.35f)
                curveTo(14.45f, 6.78f, 15.0f, 7.68f, 15.0f, 8.66f)
                curveToRelative(0.0f, 0.49f, -0.1f, 0.9f, -0.31f, 1.25f)
                reflectiveCurveTo(14.21f, 10.62f, 13.8f, 11.0f)
                curveToRelative(-0.32f, 0.3f, -0.53f, 0.56f, -0.65f, 0.77f)
                reflectiveCurveToRelative(-0.18f, 0.49f, -0.18f, 0.81f)
                verticalLineTo(13.0f)
                horizontalLineToRelative(-1.85f)
                verticalLineToRelative(-0.66f)
                horizontalLineTo(11.13f)
                close()
                moveTo(18.0f, 10.2f)
                curveTo(18.0f, 6.57f, 15.35f, 4.0f, 12.0f, 4.0f)
                reflectiveCurveToRelative(-6.0f, 2.57f, -6.0f, 6.2f)
                curveToRelative(0.0f, 2.34f, 1.95f, 5.44f, 6.0f, 9.14f)
                curveTo(16.05f, 15.64f, 18.0f, 12.54f, 18.0f, 10.2f)
                close()
                moveTo(12.0f, 2.0f)
                curveToRelative(4.2f, 0.0f, 8.0f, 3.22f, 8.0f, 8.2f)
                curveToRelative(0.0f, 3.32f, -2.67f, 7.25f, -8.0f, 11.8f)
                curveToRelative(-5.33f, -4.55f, -8.0f, -8.48f, -8.0f, -11.8f)
                curveTo(4.0f, 5.22f, 7.8f, 2.0f, 12.0f, 2.0f)
                close()
            }
        }
        return _notListedLocation!!
    }

private var _notListedLocation: ImageVector? = null
