/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.Forward5: ImageVector
    get() {
        if (_forward5 != null) {
            return _forward5!!
        }
        _forward5 = materialIcon(name = "Filled.Forward5") {
            materialPath {
                moveTo(18.0f, 13.0f)
                curveToRelative(0.0f, 3.31f, -2.69f, 6.0f, -6.0f, 6.0f)
                reflectiveCurveToRelative(-6.0f, -2.69f, -6.0f, -6.0f)
                reflectiveCurveToRelative(2.69f, -6.0f, 6.0f, -6.0f)
                verticalLineToRelative(4.0f)
                lineToRelative(5.0f, -5.0f)
                lineToRelative(-5.0f, -5.0f)
                verticalLineToRelative(4.0f)
                curveToRelative(-4.42f, 0.0f, -8.0f, 3.58f, -8.0f, 8.0f)
                curveToRelative(0.0f, 4.42f, 3.58f, 8.0f, 8.0f, 8.0f)
                curveToRelative(4.42f, 0.0f, 8.0f, -3.58f, 8.0f, -8.0f)
                horizontalLineTo(18.0f)
                close()
            }
            materialPath {
                moveTo(12.03f, 15.38f)
                curveToRelative(-0.44f, 0.0f, -0.58f, -0.31f, -0.6f, -0.56f)
                horizontalLineToRelative(-0.84f)
                curveToRelative(0.03f, 0.85f, 0.79f, 1.25f, 1.44f, 1.25f)
                curveToRelative(0.93f, 0.0f, 1.44f, -0.63f, 1.44f, -1.43f)
                curveToRelative(0.0f, -1.33f, -0.97f, -1.44f, -1.3f, -1.44f)
                curveToRelative(-0.2f, 0.0f, -0.43f, 0.05f, -0.64f, 0.16f)
                lineToRelative(0.11f, -0.92f)
                horizontalLineToRelative(1.7f)
                verticalLineToRelative(-0.71f)
                horizontalLineToRelative(-2.39f)
                lineToRelative(-0.25f, 2.17f)
                lineToRelative(0.67f, 0.17f)
                curveToRelative(0.13f, -0.13f, 0.28f, -0.23f, 0.57f, -0.23f)
                curveToRelative(0.4f, 0.0f, 0.69f, 0.23f, 0.69f, 0.75f)
                curveTo(12.62f, 14.64f, 12.65f, 15.38f, 12.03f, 15.38f)
                close()
            }
        }
        return _forward5!!
    }

private var _forward5: ImageVector? = null
