/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.OnDeviceTraining: ImageVector
    get() {
        if (_onDeviceTraining != null) {
            return _onDeviceTraining!!
        }
        _onDeviceTraining = materialIcon(name = "Filled.OnDeviceTraining") {
            materialPath {
                moveTo(11.0f, 16.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(1.0f)
                horizontalLineToRelative(-2.0f)
                close()
            }
            materialPath {
                moveTo(12.0f, 11.0f)
                curveToRelative(-1.1f, 0.0f, -2.0f, 0.9f, -2.0f, 2.0f)
                curveToRelative(0.0f, 0.74f, 0.4f, 1.38f, 1.0f, 1.72f)
                verticalLineToRelative(0.78f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(-0.78f)
                curveToRelative(0.6f, -0.35f, 1.0f, -0.98f, 1.0f, -1.72f)
                curveTo(14.0f, 11.9f, 13.1f, 11.0f, 12.0f, 11.0f)
                close()
            }
            materialPath {
                moveTo(18.0f, 1.01f)
                lineTo(6.0f, 1.0f)
                curveTo(4.9f, 1.0f, 4.0f, 1.9f, 4.0f, 3.0f)
                verticalLineToRelative(18.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(12.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                verticalLineTo(3.0f)
                curveTo(20.0f, 1.9f, 19.1f, 1.01f, 18.0f, 1.01f)
                close()
                moveTo(18.0f, 18.0f)
                horizontalLineTo(6.0f)
                verticalLineTo(6.0f)
                horizontalLineToRelative(12.0f)
                verticalLineTo(18.0f)
                close()
            }
            materialPath {
                moveTo(16.01f, 15.95f)
                curveTo(16.63f, 15.12f, 17.0f, 14.11f, 17.0f, 13.0f)
                reflectiveCurveToRelative(-0.37f, -2.12f, -0.99f, -2.95f)
                lineToRelative(-1.07f, 1.07f)
                curveToRelative(0.35f, 0.54f, 0.56f, 1.19f, 0.56f, 1.88f)
                reflectiveCurveToRelative(-0.21f, 1.34f, -0.56f, 1.88f)
                lineTo(16.01f, 15.95f)
                close()
            }
            materialPath {
                moveTo(9.06f, 14.88f)
                curveTo(8.71f, 14.34f, 8.5f, 13.69f, 8.5f, 13.0f)
                curveToRelative(0.0f, -1.93f, 1.57f, -3.5f, 3.5f, -3.5f)
                verticalLineToRelative(1.25f)
                lineToRelative(2.25f, -2.0f)
                lineToRelative(-2.25f, -2.0f)
                verticalLineTo(8.0f)
                curveToRelative(-2.76f, 0.0f, -5.0f, 2.24f, -5.0f, 5.0f)
                curveToRelative(0.0f, 1.11f, 0.37f, 2.12f, 0.99f, 2.95f)
                lineTo(9.06f, 14.88f)
                close()
            }
        }
        return _onDeviceTraining!!
    }

private var _onDeviceTraining: ImageVector? = null
