/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.TextRotationNone: ImageVector
    get() {
        if (_textRotationNone != null) {
            return _textRotationNone!!
        }
        _textRotationNone = materialIcon(name = "Filled.TextRotationNone") {
            materialPath {
                moveTo(12.75f, 3.0f)
                horizontalLineToRelative(-1.5f)
                lineTo(6.5f, 14.0f)
                horizontalLineToRelative(2.1f)
                lineToRelative(0.9f, -2.2f)
                horizontalLineToRelative(5.0f)
                lineToRelative(0.9f, 2.2f)
                horizontalLineToRelative(2.1f)
                lineTo(12.75f, 3.0f)
                close()
                moveTo(10.13f, 10.0f)
                lineTo(12.0f, 4.98f)
                lineTo(13.87f, 10.0f)
                horizontalLineToRelative(-3.74f)
                close()
                moveTo(20.5f, 18.0f)
                lineToRelative(-3.0f, -3.0f)
                verticalLineToRelative(2.0f)
                lineTo(5.0f, 17.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(12.5f)
                verticalLineToRelative(2.0f)
                lineToRelative(3.0f, -3.0f)
                close()
            }
        }
        return _textRotationNone!!
    }

private var _textRotationNone: ImageVector? = null
