/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.Tram: ImageVector
    get() {
        if (_tram != null) {
            return _tram!!
        }
        _tram = materialIcon(name = "Filled.Tram") {
            materialPath {
                moveTo(19.0f, 16.94f)
                lineTo(19.0f, 8.5f)
                curveToRelative(0.0f, -2.79f, -2.61f, -3.4f, -6.01f, -3.49f)
                lineToRelative(0.76f, -1.51f)
                lineTo(17.0f, 3.5f)
                lineTo(17.0f, 2.0f)
                lineTo(7.0f, 2.0f)
                verticalLineToRelative(1.5f)
                horizontalLineToRelative(4.75f)
                lineToRelative(-0.76f, 1.52f)
                curveTo(7.86f, 5.11f, 5.0f, 5.73f, 5.0f, 8.5f)
                verticalLineToRelative(8.44f)
                curveToRelative(0.0f, 1.45f, 1.19f, 2.66f, 2.59f, 2.97f)
                lineTo(6.0f, 21.5f)
                verticalLineToRelative(0.5f)
                horizontalLineToRelative(2.23f)
                lineToRelative(2.0f, -2.0f)
                lineTo(14.0f, 20.0f)
                lineToRelative(2.0f, 2.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(-0.5f)
                lineTo(16.5f, 20.0f)
                horizontalLineToRelative(-0.08f)
                curveToRelative(1.69f, 0.0f, 2.58f, -1.37f, 2.58f, -3.06f)
                close()
                moveTo(12.0f, 18.5f)
                curveToRelative(-0.83f, 0.0f, -1.5f, -0.67f, -1.5f, -1.5f)
                reflectiveCurveToRelative(0.67f, -1.5f, 1.5f, -1.5f)
                reflectiveCurveToRelative(1.5f, 0.67f, 1.5f, 1.5f)
                reflectiveCurveToRelative(-0.67f, 1.5f, -1.5f, 1.5f)
                close()
                moveTo(17.0f, 14.0f)
                lineTo(7.0f, 14.0f)
                lineTo(7.0f, 9.0f)
                horizontalLineToRelative(10.0f)
                verticalLineToRelative(5.0f)
                close()
            }
        }
        return _tram!!
    }

private var _tram: ImageVector? = null
