/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Outlined.Biotech: ImageVector
    get() {
        if (_biotech != null) {
            return _biotech!!
        }
        _biotech = materialIcon(name = "Outlined.Biotech") {
            materialPath {
                moveTo(7.0f, 19.0f)
                curveToRelative(-1.1f, 0.0f, -2.0f, 0.9f, -2.0f, 2.0f)
                horizontalLineToRelative(14.0f)
                curveToRelative(0.0f, -1.1f, -0.9f, -2.0f, -2.0f, -2.0f)
                horizontalLineToRelative(-4.0f)
                verticalLineToRelative(-2.0f)
                horizontalLineToRelative(3.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                horizontalLineToRelative(-8.0f)
                curveToRelative(-1.66f, 0.0f, -3.0f, -1.34f, -3.0f, -3.0f)
                curveToRelative(0.0f, -1.09f, 0.59f, -2.04f, 1.47f, -2.57f)
                curveToRelative(0.41f, 0.59f, 1.06f, 1.0f, 1.83f, 1.06f)
                curveToRelative(0.7f, 0.06f, 1.36f, -0.19f, 1.85f, -0.62f)
                lineToRelative(0.59f, 1.61f)
                lineToRelative(0.94f, -0.34f)
                lineToRelative(0.34f, 0.94f)
                lineToRelative(1.88f, -0.68f)
                lineToRelative(-0.34f, -0.94f)
                lineToRelative(0.94f, -0.34f)
                lineTo(13.76f, 2.6f)
                lineToRelative(-0.94f, 0.34f)
                lineTo(12.48f, 2.0f)
                lineTo(10.6f, 2.68f)
                lineToRelative(0.34f, 0.94f)
                lineTo(10.0f, 3.97f)
                lineToRelative(0.56f, 1.55f)
                curveTo(9.39f, 5.48f, 8.37f, 6.27f, 8.08f, 7.38f)
                curveTo(6.27f, 8.14f, 5.0f, 9.92f, 5.0f, 12.0f)
                curveToRelative(0.0f, 2.76f, 2.24f, 5.0f, 5.0f, 5.0f)
                verticalLineToRelative(2.0f)
                horizontalLineTo(7.0f)
                close()
                moveTo(12.86f, 4.52f)
                lineToRelative(1.71f, 4.7f)
                lineToRelative(-0.94f, 0.34f)
                lineToRelative(-1.71f, -4.7f)
                lineTo(12.86f, 4.52f)
                close()
                moveTo(10.5f, 7.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, 0.45f, 1.0f, 1.0f)
                curveToRelative(0.0f, 0.55f, -0.45f, 1.0f, -1.0f, 1.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, -0.45f, -1.0f, -1.0f)
                curveTo(9.5f, 7.45f, 9.95f, 7.0f, 10.5f, 7.0f)
                close()
            }
        }
        return _biotech!!
    }

private var _biotech: ImageVector? = null
