/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Outlined.SimCardDownload: ImageVector
    get() {
        if (_simCardDownload != null) {
            return _simCardDownload!!
        }
        _simCardDownload = materialIcon(name = "Outlined.SimCardDownload") {
            materialPath {
                moveTo(18.0f, 2.0f)
                horizontalLineToRelative(-8.0f)
                lineTo(4.0f, 8.0f)
                verticalLineToRelative(12.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(12.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                verticalLineTo(4.0f)
                curveTo(20.0f, 2.9f, 19.1f, 2.0f, 18.0f, 2.0f)
                close()
                moveTo(18.0f, 4.0f)
                verticalLineToRelative(16.0f)
                horizontalLineTo(6.0f)
                verticalLineTo(8.83f)
                lineTo(10.83f, 4.0f)
                horizontalLineTo(18.0f)
                close()
            }
            materialPath {
                moveTo(16.0f, 13.0f)
                lineToRelative(-4.0f, 4.0f)
                lineToRelative(-4.0f, -4.0f)
                lineToRelative(1.41f, -1.41f)
                lineTo(11.0f, 13.17f)
                verticalLineTo(9.02f)
                lineTo(13.0f, 9.0f)
                verticalLineToRelative(4.17f)
                lineToRelative(1.59f, -1.59f)
                lineTo(16.0f, 13.0f)
                close()
            }
        }
        return _simCardDownload!!
    }

private var _simCardDownload: ImageVector? = null
