/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector
import kotlin.Deprecated

@Deprecated(
    "Use the AutoMirrored version at Icons.AutoMirrored.Rounded.AlignHorizontalRight",
    ReplaceWith( "Icons.AutoMirrored.Rounded.AlignHorizontalRight",
            "androidx.compose.material.icons.automirrored.rounded.AlignHorizontalRight"),
)
public val Icons.Rounded.AlignHorizontalRight: ImageVector
    get() {
        if (_alignHorizontalRight != null) {
            return _alignHorizontalRight!!
        }
        _alignHorizontalRight = materialIcon(name = "Rounded.AlignHorizontalRight") {
            materialPath {
                moveTo(21.0f, 2.0f)
                lineTo(21.0f, 2.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, 0.45f, 1.0f, 1.0f)
                verticalLineToRelative(18.0f)
                curveToRelative(0.0f, 0.55f, -0.45f, 1.0f, -1.0f, 1.0f)
                horizontalLineToRelative(0.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, -0.45f, -1.0f, -1.0f)
                verticalLineTo(3.0f)
                curveTo(20.0f, 2.45f, 20.45f, 2.0f, 21.0f, 2.0f)
                close()
                moveTo(3.5f, 10.0f)
                horizontalLineToRelative(13.0f)
                curveToRelative(0.83f, 0.0f, 1.5f, -0.67f, 1.5f, -1.5f)
                verticalLineToRelative(0.0f)
                curveTo(18.0f, 7.67f, 17.33f, 7.0f, 16.5f, 7.0f)
                horizontalLineToRelative(-13.0f)
                curveTo(2.67f, 7.0f, 2.0f, 7.67f, 2.0f, 8.5f)
                verticalLineToRelative(0.0f)
                curveTo(2.0f, 9.33f, 2.67f, 10.0f, 3.5f, 10.0f)
                close()
                moveTo(9.5f, 17.0f)
                horizontalLineToRelative(7.0f)
                curveToRelative(0.83f, 0.0f, 1.5f, -0.67f, 1.5f, -1.5f)
                verticalLineToRelative(0.0f)
                curveToRelative(0.0f, -0.83f, -0.67f, -1.5f, -1.5f, -1.5f)
                horizontalLineToRelative(-7.0f)
                curveTo(8.67f, 14.0f, 8.0f, 14.67f, 8.0f, 15.5f)
                verticalLineToRelative(0.0f)
                curveTo(8.0f, 16.33f, 8.67f, 17.0f, 9.5f, 17.0f)
                close()
            }
        }
        return _alignHorizontalRight!!
    }

private var _alignHorizontalRight: ImageVector? = null
