/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.HistoryEdu: ImageVector
    get() {
        if (_historyEdu != null) {
            return _historyEdu!!
        }
        _historyEdu = materialIcon(name = "Rounded.HistoryEdu") {
            materialPath {
                moveTo(9.0f, 5.0f)
                verticalLineToRelative(0.38f)
                curveToRelative(-0.83f, -0.33f, -1.72f, -0.5f, -2.61f, -0.5f)
                curveToRelative(-1.42f, 0.0f, -2.84f, 0.43f, -4.05f, 1.29f)
                curveTo(1.83f, 6.53f, 1.77f, 7.26f, 2.21f, 7.7f)
                lineToRelative(2.57f, 2.57f)
                horizontalLineToRelative(1.11f)
                verticalLineToRelative(1.11f)
                curveToRelative(0.86f, 0.86f, 1.98f, 1.31f, 3.11f, 1.36f)
                verticalLineTo(15.0f)
                horizontalLineTo(7.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, 0.45f, -1.0f, 1.0f)
                verticalLineToRelative(2.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(10.0f)
                curveToRelative(1.66f, 0.0f, 3.0f, -1.34f, 3.0f, -3.0f)
                verticalLineTo(5.0f)
                curveToRelative(0.0f, -0.55f, -0.45f, -1.0f, -1.0f, -1.0f)
                horizontalLineTo(10.0f)
                curveTo(9.45f, 4.0f, 9.0f, 4.45f, 9.0f, 5.0f)
                close()
                moveTo(7.89f, 10.41f)
                verticalLineTo(8.26f)
                horizontalLineTo(5.61f)
                lineTo(4.57f, 7.22f)
                curveTo(5.14f, 7.0f, 5.76f, 6.88f, 6.39f, 6.88f)
                curveToRelative(1.34f, 0.0f, 2.59f, 0.52f, 3.54f, 1.46f)
                lineToRelative(1.41f, 1.41f)
                lineToRelative(-0.2f, 0.2f)
                curveToRelative(-0.51f, 0.51f, -1.19f, 0.8f, -1.92f, 0.8f)
                curveTo(8.75f, 10.75f, 8.29f, 10.63f, 7.89f, 10.41f)
                close()
                moveTo(19.0f, 17.0f)
                curveToRelative(0.0f, 0.55f, -0.45f, 1.0f, -1.0f, 1.0f)
                reflectiveCurveToRelative(-1.0f, -0.45f, -1.0f, -1.0f)
                verticalLineToRelative(-1.0f)
                curveToRelative(0.0f, -0.55f, -0.45f, -1.0f, -1.0f, -1.0f)
                horizontalLineToRelative(-5.0f)
                verticalLineToRelative(-2.59f)
                curveToRelative(0.57f, -0.23f, 1.1f, -0.57f, 1.56f, -1.03f)
                lineToRelative(0.2f, -0.2f)
                lineTo(15.59f, 14.0f)
                horizontalLineTo(17.0f)
                verticalLineToRelative(-1.41f)
                lineToRelative(-6.0f, -5.97f)
                verticalLineTo(6.0f)
                horizontalLineToRelative(8.0f)
                verticalLineTo(17.0f)
                close()
            }
        }
        return _historyEdu!!
    }

private var _historyEdu: ImageVector? = null
