/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.Quickreply: ImageVector
    get() {
        if (_quickreply != null) {
            return _quickreply!!
        }
        _quickreply = materialIcon(name = "Sharp.Quickreply") {
            materialPath {
                moveTo(22.0f, 2.0f)
                lineToRelative(-20.0f, 0.0f)
                lineToRelative(0.0f, 20.0f)
                lineToRelative(4.0f, -4.0f)
                lineToRelative(9.0f, 0.0f)
                lineToRelative(0.0f, -8.0f)
                lineToRelative(7.0f, 0.0f)
                close()
            }
            materialPath {
                moveTo(22.5f, 16.0f)
                lineToRelative(-2.2f, 0.0f)
                lineToRelative(1.7f, -4.0f)
                lineToRelative(-5.0f, 0.0f)
                lineToRelative(0.0f, 6.0f)
                lineToRelative(2.0f, 0.0f)
                lineToRelative(0.0f, 5.0f)
                close()
            }
        }
        return _quickreply!!
    }

private var _quickreply: ImageVector? = null
