/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.SettingsOverscan: ImageVector
    get() {
        if (_settingsOverscan != null) {
            return _settingsOverscan!!
        }
        _settingsOverscan = materialIcon(name = "Sharp.SettingsOverscan") {
            materialPath {
                moveTo(12.01f, 5.5f)
                lineTo(10.0f, 8.0f)
                horizontalLineToRelative(4.0f)
                lineToRelative(-1.99f, -2.5f)
                close()
                moveTo(18.0f, 10.0f)
                verticalLineToRelative(4.0f)
                lineToRelative(2.5f, -1.99f)
                lineTo(18.0f, 10.0f)
                close()
                moveTo(6.0f, 10.0f)
                lineToRelative(-2.5f, 2.01f)
                lineTo(6.0f, 14.0f)
                verticalLineToRelative(-4.0f)
                close()
                moveTo(14.0f, 16.0f)
                horizontalLineToRelative(-4.0f)
                lineToRelative(2.01f, 2.5f)
                lineTo(14.0f, 16.0f)
                close()
                moveTo(23.0f, 3.0f)
                lineTo(1.0f, 3.0f)
                verticalLineToRelative(18.0f)
                horizontalLineToRelative(22.0f)
                lineTo(23.0f, 3.0f)
                close()
                moveTo(21.0f, 19.01f)
                lineTo(3.0f, 19.01f)
                lineTo(3.0f, 4.99f)
                horizontalLineToRelative(18.0f)
                verticalLineToRelative(14.02f)
                close()
            }
        }
        return _settingsOverscan!!
    }

private var _settingsOverscan: ImageVector? = null
