/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.LineAxis: ImageVector
    get() {
        if (_lineAxis != null) {
            return _lineAxis!!
        }
        _lineAxis = materialIcon(name = "TwoTone.LineAxis") {
            materialPath {
                moveTo(22.0f, 7.43f)
                lineToRelative(-1.41f, -1.41f)
                lineToRelative(-4.03f, 4.53f)
                lineToRelative(-7.06f, -6.55f)
                lineToRelative(-7.5f, 7.51f)
                lineToRelative(1.5f, 1.5f)
                lineToRelative(6.14f, -6.15f)
                lineToRelative(5.59f, 5.18f)
                lineToRelative(-1.73f, 1.95f)
                lineToRelative(-4.0f, -4.0f)
                lineToRelative(-7.5f, 7.51f)
                lineToRelative(1.5f, 1.5f)
                lineToRelative(6.0f, -6.01f)
                lineToRelative(4.0f, 4.0f)
                lineToRelative(3.19f, -3.59f)
                lineToRelative(3.9f, 3.61f)
                lineToRelative(1.41f, -1.41f)
                lineToRelative(-3.98f, -3.7f)
                close()
            }
        }
        return _lineAxis!!
    }

private var _lineAxis: ImageVector? = null
