/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.TempleBuddhist: ImageVector
    get() {
        if (_templeBuddhist != null) {
            return _templeBuddhist!!
        }
        _templeBuddhist = materialIcon(name = "Filled.TempleBuddhist") {
            materialPath {
                moveTo(21.0f, 9.02f)
                curveToRelative(0.0f, 1.09f, -0.89f, 1.98f, -1.98f, 1.98f)
                horizontalLineTo(4.98f)
                curveTo(3.89f, 11.0f, 3.0f, 10.11f, 3.0f, 9.02f)
                horizontalLineTo(1.0f)
                curveToRelative(0.0f, 1.86f, 1.28f, 3.4f, 3.0f, 3.84f)
                verticalLineTo(22.0f)
                horizontalLineToRelative(6.0f)
                verticalLineToRelative(-3.0f)
                curveToRelative(0.0f, -1.1f, 0.9f, -2.0f, 2.0f, -2.0f)
                reflectiveCurveToRelative(2.0f, 0.9f, 2.0f, 2.0f)
                verticalLineToRelative(3.0f)
                horizontalLineToRelative(6.0f)
                verticalLineToRelative(-9.14f)
                curveToRelative(0.55f, -0.14f, 3.0f, -1.04f, 3.0f, -3.86f)
                lineTo(21.0f, 9.02f)
                close()
            }
            materialPath {
                moveTo(6.0f, 8.86f)
                verticalLineTo(10.0f)
                horizontalLineToRelative(12.0f)
                verticalLineTo(8.86f)
                curveToRelative(0.55f, -0.14f, 3.0f, -1.04f, 3.0f, -3.86f)
                lineToRelative(-2.0f, 0.02f)
                curveTo(19.0f, 6.11f, 18.11f, 7.0f, 17.02f, 7.0f)
                horizontalLineTo(6.98f)
                curveTo(5.89f, 7.0f, 5.0f, 6.11f, 5.0f, 5.02f)
                horizontalLineTo(3.0f)
                curveTo(3.0f, 6.87f, 4.28f, 8.42f, 6.0f, 8.86f)
                close()
            }
            materialPath {
                moveTo(12.0f, 1.0f)
                lineToRelative(-3.75f, 5.0f)
                lineToRelative(7.5f, 0.0f)
                close()
            }
        }
        return _templeBuddhist!!
    }

private var _templeBuddhist: ImageVector? = null
