/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.WifiProtectedSetup: ImageVector
    get() {
        if (_wifiProtectedSetup != null) {
            return _wifiProtectedSetup!!
        }
        _wifiProtectedSetup = materialIcon(name = "Filled.WifiProtectedSetup") {
            materialPath {
                moveTo(16.71f, 5.29f)
                lineTo(19.0f, 3.0f)
                horizontalLineToRelative(-8.0f)
                verticalLineToRelative(8.0f)
                lineToRelative(2.3f, -2.3f)
                curveToRelative(1.97f, 1.46f, 3.25f, 3.78f, 3.25f, 6.42f)
                curveToRelative(0.0f, 1.31f, -0.32f, 2.54f, -0.88f, 3.63f)
                curveToRelative(2.33f, -1.52f, 3.88f, -4.14f, 3.88f, -7.13f)
                curveTo(19.55f, 9.1f, 18.44f, 6.85f, 16.71f, 5.29f)
                close()
            }
            materialPath {
                moveTo(7.46f, 8.88f)
                curveToRelative(0.0f, -1.31f, 0.32f, -2.54f, 0.88f, -3.63f)
                curveTo(6.0f, 6.77f, 4.46f, 9.39f, 4.46f, 12.38f)
                curveToRelative(0.0f, 2.52f, 1.1f, 4.77f, 2.84f, 6.33f)
                lineTo(5.0f, 21.0f)
                horizontalLineToRelative(8.0f)
                verticalLineToRelative(-8.0f)
                lineToRelative(-2.3f, 2.3f)
                curveTo(8.74f, 13.84f, 7.46f, 11.52f, 7.46f, 8.88f)
                close()
            }
        }
        return _wifiProtectedSetup!!
    }

private var _wifiProtectedSetup: ImageVector? = null
