/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Outlined.Contactless: ImageVector
    get() {
        if (_contactless != null) {
            return _contactless!!
        }
        _contactless = materialIcon(name = "Outlined.Contactless") {
            materialPath {
                moveTo(12.0f, 2.0f)
                curveTo(6.48f, 2.0f, 2.0f, 6.48f, 2.0f, 12.0f)
                curveToRelative(0.0f, 5.52f, 4.48f, 10.0f, 10.0f, 10.0f)
                reflectiveCurveToRelative(10.0f, -4.48f, 10.0f, -10.0f)
                curveTo(22.0f, 6.48f, 17.52f, 2.0f, 12.0f, 2.0f)
                close()
                moveTo(12.0f, 20.0f)
                curveToRelative(-4.42f, 0.0f, -8.0f, -3.58f, -8.0f, -8.0f)
                reflectiveCurveToRelative(3.58f, -8.0f, 8.0f, -8.0f)
                reflectiveCurveToRelative(8.0f, 3.58f, 8.0f, 8.0f)
                reflectiveCurveTo(16.42f, 20.0f, 12.0f, 20.0f)
                close()
            }
            materialPath {
                moveTo(7.1f, 10.18f)
                curveToRelative(0.26f, 0.56f, 0.39f, 1.16f, 0.4f, 1.8f)
                curveToRelative(0.01f, 0.63f, -0.13f, 1.25f, -0.4f, 1.86f)
                lineToRelative(1.37f, 0.62f)
                curveToRelative(0.37f, -0.81f, 0.55f, -1.65f, 0.54f, -2.5f)
                curveToRelative(-0.01f, -0.84f, -0.19f, -1.65f, -0.54f, -2.4f)
                lineTo(7.1f, 10.18f)
                close()
            }
            materialPath {
                moveTo(13.33f, 7.33f)
                curveToRelative(0.78f, 1.57f, 1.18f, 3.14f, 1.18f, 4.64f)
                curveToRelative(0.0f, 1.51f, -0.4f, 3.09f, -1.18f, 4.69f)
                lineToRelative(1.35f, 0.66f)
                curveToRelative(0.88f, -1.81f, 1.33f, -3.61f, 1.33f, -5.35f)
                curveToRelative(0.0f, -1.74f, -0.45f, -3.53f, -1.33f, -5.31f)
                lineTo(13.33f, 7.33f)
                close()
            }
            materialPath {
                moveTo(10.2f, 8.72f)
                curveToRelative(0.53f, 1.07f, 0.8f, 2.21f, 0.8f, 3.4f)
                curveToRelative(0.0f, 1.17f, -0.26f, 2.23f, -0.78f, 3.15f)
                lineToRelative(1.3f, 0.74f)
                curveToRelative(0.65f, -1.15f, 0.98f, -2.45f, 0.98f, -3.89f)
                curveToRelative(0.0f, -1.42f, -0.32f, -2.79f, -0.96f, -4.07f)
                lineTo(10.2f, 8.72f)
                close()
            }
        }
        return _contactless!!
    }

private var _contactless: ImageVector? = null
