/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.NightlightRound: ImageVector
    get() {
        if (_nightlightRound != null) {
            return _nightlightRound!!
        }
        _nightlightRound = materialIcon(name = "Rounded.NightlightRound") {
            materialPath {
                moveTo(15.5f, 22.0f)
                curveToRelative(0.07f, 0.0f, 0.14f, 0.0f, 0.21f, 0.0f)
                curveToRelative(0.84f, -0.02f, 1.12f, -1.11f, 0.41f, -1.56f)
                curveToRelative(-2.78f, -1.77f, -4.63f, -4.89f, -4.63f, -8.43f)
                curveToRelative(0.0f, -3.55f, 1.85f, -6.66f, 4.63f, -8.44f)
                curveToRelative(0.7f, -0.45f, 0.44f, -1.54f, -0.39f, -1.56f)
                curveToRelative(-0.04f, 0.0f, -0.09f, 0.0f, -0.13f, 0.0f)
                curveToRelative(-4.9f, -0.05f, -9.21f, 3.53f, -9.98f, 8.37f)
                curveTo(4.64f, 16.61f, 9.45f, 22.0f, 15.5f, 22.0f)
                lineTo(15.5f, 22.0f)
                close()
            }
        }
        return _nightlightRound!!
    }

private var _nightlightRound: ImageVector? = null
