/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.BookmarkRemove: ImageVector
    get() {
        if (_bookmarkRemove != null) {
            return _bookmarkRemove!!
        }
        _bookmarkRemove = materialIcon(name = "Sharp.BookmarkRemove") {
            materialPath {
                moveTo(21.0f, 7.0f)
                horizontalLineToRelative(-6.0f)
                verticalLineTo(5.0f)
                horizontalLineToRelative(6.0f)
                verticalLineTo(7.0f)
                close()
                moveTo(19.0f, 10.9f)
                curveToRelative(-0.64f, 0.13f, -1.32f, 0.14f, -2.02f, 0.0f)
                curveToRelative(-1.91f, -0.38f, -3.47f, -1.92f, -3.87f, -3.83f)
                curveTo(12.79f, 5.54f, 13.18f, 4.1f, 14.0f, 3.0f)
                lineTo(5.0f, 3.0f)
                verticalLineToRelative(18.0f)
                lineToRelative(7.0f, -3.0f)
                lineToRelative(7.0f, 3.0f)
                verticalLineTo(10.9f)
                close()
            }
        }
        return _bookmarkRemove!!
    }

private var _bookmarkRemove: ImageVector? = null
