/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.Interests: ImageVector
    get() {
        if (_interests != null) {
            return _interests!!
        }
        _interests = materialIcon(name = "Sharp.Interests") {
            materialPath {
                moveTo(7.02f, 13.0f)
                curveToRelative(-2.21f, 0.0f, -4.0f, 1.79f, -4.0f, 4.0f)
                reflectiveCurveToRelative(1.79f, 4.0f, 4.0f, 4.0f)
                reflectiveCurveToRelative(4.0f, -1.79f, 4.0f, -4.0f)
                reflectiveCurveTo(9.23f, 13.0f, 7.02f, 13.0f)
                close()
                moveTo(13.0f, 13.0f)
                verticalLineToRelative(8.0f)
                horizontalLineToRelative(8.0f)
                verticalLineToRelative(-8.0f)
                horizontalLineTo(13.0f)
                close()
                moveTo(7.0f, 2.0f)
                lineToRelative(-5.0f, 9.0f)
                horizontalLineToRelative(10.0f)
                lineTo(7.0f, 2.0f)
                close()
                moveTo(19.25f, 2.5f)
                curveToRelative(-1.06f, 0.0f, -1.81f, 0.56f, -2.25f, 1.17f)
                curveToRelative(-0.44f, -0.61f, -1.19f, -1.17f, -2.25f, -1.17f)
                curveTo(13.19f, 2.5f, 12.0f, 3.78f, 12.0f, 5.25f)
                curveToRelative(0.0f, 2.0f, 2.42f, 3.42f, 5.0f, 5.75f)
                curveToRelative(2.58f, -2.33f, 5.0f, -3.75f, 5.0f, -5.75f)
                curveTo(22.0f, 3.78f, 20.81f, 2.5f, 19.25f, 2.5f)
                close()
            }
        }
        return _interests!!
    }

private var _interests: ImageVector? = null
