/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.SwipeUp: ImageVector
    get() {
        if (_swipeUp != null) {
            return _swipeUp!!
        }
        _swipeUp = materialIcon(name = "Filled.SwipeUp") {
            materialPath {
                moveTo(2.06f, 5.56f)
                lineTo(1.0f, 4.5f)
                lineTo(4.5f, 1.0f)
                lineTo(8.0f, 4.5f)
                lineTo(6.94f, 5.56f)
                lineTo(5.32f, 3.94f)
                curveTo(5.11f, 4.76f, 5.0f, 5.62f, 5.0f, 6.5f)
                curveToRelative(0.0f, 2.42f, 0.82f, 4.65f, 2.2f, 6.43f)
                lineTo(6.13f, 14.0f)
                curveTo(4.49f, 11.95f, 3.5f, 9.34f, 3.5f, 6.5f)
                curveToRelative(0.0f, -0.92f, 0.1f, -1.82f, 0.3f, -2.68f)
                lineTo(2.06f, 5.56f)
                close()
                moveTo(13.85f, 11.62f)
                lineToRelative(-2.68f, -5.37f)
                curveToRelative(-0.37f, -0.74f, -1.27f, -1.04f, -2.01f, -0.67f)
                curveTo(8.41f, 5.96f, 8.11f, 6.86f, 8.48f, 7.6f)
                lineToRelative(4.81f, 9.6f)
                lineTo(10.05f, 18.0f)
                curveToRelative(-0.33f, 0.09f, -0.59f, 0.33f, -0.7f, 0.66f)
                lineTo(9.0f, 19.78f)
                lineToRelative(6.19f, 2.25f)
                curveToRelative(0.5f, 0.17f, 1.28f, 0.02f, 1.75f, -0.22f)
                lineToRelative(5.51f, -2.75f)
                curveToRelative(0.89f, -0.45f, 1.32f, -1.48f, 1.0f, -2.42f)
                lineToRelative(-1.43f, -4.27f)
                curveToRelative(-0.27f, -0.82f, -1.04f, -1.37f, -1.9f, -1.37f)
                horizontalLineToRelative(-4.56f)
                curveToRelative(-0.31f, 0.0f, -0.62f, 0.07f, -0.89f, 0.21f)
                lineTo(13.85f, 11.62f)
            }
        }
        return _swipeUp!!
    }

private var _swipeUp: ImageVector? = null
