/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.ThumbDownOffAlt: ImageVector
    get() {
        if (_thumbDownOffAlt != null) {
            return _thumbDownOffAlt!!
        }
        _thumbDownOffAlt = materialIcon(name = "Sharp.ThumbDownOffAlt") {
            materialPath {
                moveTo(19.0f, 3.0f)
                horizontalLineToRelative(4.0f)
                verticalLineToRelative(12.0f)
                horizontalLineToRelative(-4.0f)
                close()
            }
            materialPath {
                moveTo(1.0f, 11.6f)
                verticalLineTo(16.0f)
                horizontalLineToRelative(8.31f)
                lineToRelative(-1.12f, 5.38f)
                lineTo(9.83f, 23.0f)
                lineTo(17.0f, 15.82f)
                verticalLineTo(3.0f)
                horizontalLineTo(4.69f)
                lineTo(1.0f, 11.6f)
                close()
                moveTo(15.0f, 5.0f)
                verticalLineToRelative(9.99f)
                lineToRelative(-4.34f, 4.35f)
                lineToRelative(0.61f, -2.93f)
                lineToRelative(0.5f, -2.41f)
                horizontalLineTo(9.31f)
                horizontalLineTo(3.0f)
                verticalLineToRelative(-1.99f)
                lineTo(6.01f, 5.0f)
                horizontalLineTo(15.0f)
                close()
            }
        }
        return _thumbDownOffAlt!!
    }

private var _thumbDownOffAlt: ImageVector? = null
