/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.MobileOff: ImageVector
    get() {
        if (_mobileOff != null) {
            return _mobileOff!!
        }
        _mobileOff = materialIcon(name = "Filled.MobileOff") {
            materialPath {
                moveTo(2.76f, 2.49f)
                lineTo(1.49f, 3.76f)
                lineTo(5.0f, 7.27f)
                verticalLineTo(21.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(10.0f)
                curveToRelative(1.02f, 0.0f, 1.85f, -0.77f, 1.98f, -1.75f)
                lineToRelative(1.72f, 1.72f)
                lineToRelative(1.27f, -1.27f)
                lineTo(2.76f, 2.49f)
                close()
                moveTo(7.0f, 19.0f)
                verticalLineTo(9.27f)
                lineTo(16.73f, 19.0f)
                horizontalLineTo(7.0f)
                close()
                moveTo(17.0f, 5.0f)
                verticalLineToRelative(9.17f)
                lineToRelative(2.0f, 2.0f)
                verticalLineTo(3.0f)
                curveToRelative(0.0f, -1.1f, -0.9f, -2.0f, -2.0f, -2.0f)
                horizontalLineTo(7.0f)
                curveToRelative(-0.85f, 0.0f, -1.58f, 0.54f, -1.87f, 1.3f)
                lineTo(7.83f, 5.0f)
                horizontalLineTo(17.0f)
                close()
            }
        }
        return _mobileOff!!
    }

private var _mobileOff: ImageVector? = null
