/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.StarRate: ImageVector
    get() {
        if (_starRate != null) {
            return _starRate!!
        }
        _starRate = materialIcon(name = "Filled.StarRate") {
            materialPath {
                moveTo(14.43f, 10.0f)
                lineToRelative(-2.43f, -8.0f)
                lineToRelative(-2.43f, 8.0f)
                lineToRelative(-7.57f, 0.0f)
                lineToRelative(6.18f, 4.41f)
                lineToRelative(-2.35f, 7.59f)
                lineToRelative(6.17f, -4.69f)
                lineToRelative(6.18f, 4.69f)
                lineToRelative(-2.35f, -7.59f)
                lineToRelative(6.17f, -4.41f)
                close()
            }
        }
        return _starRate!!
    }

private var _starRate: ImageVector? = null
