/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.Thunderstorm: ImageVector
    get() {
        if (_thunderstorm != null) {
            return _thunderstorm!!
        }
        _thunderstorm = materialIcon(name = "Filled.Thunderstorm") {
            materialPath {
                moveTo(17.92f, 7.02f)
                curveTo(17.45f, 4.18f, 14.97f, 2.0f, 12.0f, 2.0f)
                curveTo(9.82f, 2.0f, 7.83f, 3.18f, 6.78f, 5.06f)
                curveTo(4.09f, 5.41f, 2.0f, 7.74f, 2.0f, 10.5f)
                curveTo(2.0f, 13.53f, 4.47f, 16.0f, 7.5f, 16.0f)
                horizontalLineToRelative(10.0f)
                curveToRelative(2.48f, 0.0f, 4.5f, -2.02f, 4.5f, -4.5f)
                curveTo(22.0f, 9.16f, 20.21f, 7.23f, 17.92f, 7.02f)
                close()
            }
            materialPath {
                moveTo(14.8f, 17.0f)
                lineToRelative(-2.9f, 3.32f)
                lineToRelative(2.0f, 1.0f)
                lineToRelative(-2.35f, 2.68f)
                lineToRelative(2.65f, 0.0f)
                lineToRelative(2.9f, -3.32f)
                lineToRelative(-2.0f, -1.0f)
                lineToRelative(2.35f, -2.68f)
                close()
            }
            materialPath {
                moveTo(8.8f, 17.0f)
                lineToRelative(-2.9f, 3.32f)
                lineToRelative(2.0f, 1.0f)
                lineToRelative(-2.35f, 2.68f)
                lineToRelative(2.65f, 0.0f)
                lineToRelative(2.9f, -3.32f)
                lineToRelative(-2.0f, -1.0f)
                lineToRelative(2.35f, -2.68f)
                close()
            }
        }
        return _thunderstorm!!
    }

private var _thunderstorm: ImageVector? = null
