/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Outlined.ExploreOff: ImageVector
    get() {
        if (_exploreOff != null) {
            return _exploreOff!!
        }
        _exploreOff = materialIcon(name = "Outlined.ExploreOff") {
            materialPath {
                moveTo(12.0f, 4.0f)
                curveToRelative(4.41f, 0.0f, 8.0f, 3.59f, 8.0f, 8.0f)
                curveToRelative(0.0f, 1.48f, -0.41f, 2.86f, -1.12f, 4.06f)
                lineToRelative(1.46f, 1.46f)
                curveTo(21.39f, 15.93f, 22.0f, 14.04f, 22.0f, 12.0f)
                curveToRelative(0.0f, -5.52f, -4.48f, -10.0f, -10.0f, -10.0f)
                curveToRelative(-2.04f, 0.0f, -3.93f, 0.61f, -5.51f, 1.66f)
                lineToRelative(1.46f, 1.46f)
                curveTo(9.14f, 4.41f, 10.52f, 4.0f, 12.0f, 4.0f)
                close()
                moveTo(14.91f, 12.08f)
                lineTo(17.5f, 6.5f)
                lineToRelative(-5.58f, 2.59f)
                lineToRelative(2.99f, 2.99f)
                close()
                moveTo(2.1f, 4.93f)
                lineToRelative(1.56f, 1.56f)
                curveTo(2.61f, 8.07f, 2.0f, 9.96f, 2.0f, 12.0f)
                curveToRelative(0.0f, 5.52f, 4.48f, 10.0f, 10.0f, 10.0f)
                curveToRelative(2.04f, 0.0f, 3.93f, -0.61f, 5.51f, -1.66f)
                lineToRelative(1.56f, 1.56f)
                lineToRelative(1.41f, -1.41f)
                lineTo(3.51f, 3.51f)
                lineTo(2.1f, 4.93f)
                close()
                moveTo(5.12f, 7.94f)
                lineToRelative(3.98f, 3.98f)
                lineToRelative(-2.6f, 5.58f)
                lineToRelative(5.58f, -2.59f)
                lineToRelative(3.98f, 3.98f)
                curveToRelative(-1.2f, 0.7f, -2.58f, 1.11f, -4.06f, 1.11f)
                curveToRelative(-4.41f, 0.0f, -8.0f, -3.59f, -8.0f, -8.0f)
                curveToRelative(0.0f, -1.48f, 0.41f, -2.86f, 1.12f, -4.06f)
                close()
            }
        }
        return _exploreOff!!
    }

private var _exploreOff: ImageVector? = null
