/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.Brightness3: ImageVector
    get() {
        if (_brightness3 != null) {
            return _brightness3!!
        }
        _brightness3 = materialIcon(name = "Rounded.Brightness3") {
            materialPath {
                moveTo(8.93f, 2.0f)
                curveTo(8.88f, 2.0f, 8.84f, 2.0f, 8.79f, 2.0f)
                curveTo(7.96f, 2.02f, 7.7f, 3.12f, 8.4f, 3.56f)
                curveToRelative(2.78f, 1.77f, 4.63f, 4.89f, 4.63f, 8.44f)
                curveToRelative(0.0f, 3.55f, -1.84f, 6.66f, -4.62f, 8.43f)
                curveTo(7.7f, 20.89f, 7.98f, 21.98f, 8.82f, 22.0f)
                curveToRelative(0.07f, 0.0f, 0.14f, 0.0f, 0.21f, 0.0f)
                curveToRelative(6.05f, 0.0f, 10.86f, -5.39f, 9.87f, -11.63f)
                curveTo(18.14f, 5.53f, 13.83f, 1.95f, 8.93f, 2.0f)
                close()
            }
        }
        return _brightness3!!
    }

private var _brightness3: ImageVector? = null
