/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.EditLocation: ImageVector
    get() {
        if (_editLocation != null) {
            return _editLocation!!
        }
        _editLocation = materialIcon(name = "Rounded.EditLocation") {
            materialPath {
                moveTo(12.0f, 2.0f)
                curveToRelative(-4.2f, 0.0f, -8.0f, 3.22f, -8.0f, 8.2f)
                curveToRelative(0.0f, 3.18f, 2.45f, 6.92f, 7.34f, 11.23f)
                curveToRelative(0.38f, 0.33f, 0.95f, 0.33f, 1.33f, 0.0f)
                curveTo(17.55f, 17.12f, 20.0f, 13.38f, 20.0f, 10.2f)
                curveTo(20.0f, 5.22f, 16.2f, 2.0f, 12.0f, 2.0f)
                close()
                moveTo(9.73f, 13.5f)
                horizontalLineTo(8.5f)
                verticalLineToRelative(-1.44f)
                lineToRelative(3.93f, -3.92f)
                lineToRelative(1.43f, 1.43f)
                lineToRelative(-3.77f, 3.78f)
                curveTo(9.99f, 13.45f, 9.87f, 13.5f, 9.73f, 13.5f)
                close()
                moveTo(15.28f, 8.16f)
                lineToRelative(-0.7f, 0.7f)
                lineToRelative(-1.44f, -1.44f)
                lineToRelative(0.7f, -0.7f)
                curveToRelative(0.15f, -0.15f, 0.39f, -0.15f, 0.54f, 0.0f)
                lineToRelative(0.9f, 0.9f)
                curveTo(15.43f, 7.77f, 15.43f, 8.01f, 15.28f, 8.16f)
                close()
            }
        }
        return _editLocation!!
    }

private var _editLocation: ImageVector? = null
