/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.Pinch: ImageVector
    get() {
        if (_pinch != null) {
            return _pinch!!
        }
        _pinch = materialIcon(name = "Rounded.Pinch") {
            materialPath {
                moveTo(8.2f, 17.43f)
                curveToRelative(0.0f, -0.65f, 0.6f, -1.13f, 1.24f, -0.99f)
                lineTo(13.0f, 17.24f)
                verticalLineTo(6.5f)
                curveTo(13.0f, 5.67f, 13.67f, 5.0f, 14.5f, 5.0f)
                reflectiveCurveTo(16.0f, 5.67f, 16.0f, 6.5f)
                verticalLineToRelative(6.0f)
                horizontalLineToRelative(0.91f)
                curveToRelative(0.31f, 0.0f, 0.62f, 0.07f, 0.89f, 0.21f)
                lineToRelative(4.09f, 2.04f)
                curveToRelative(0.77f, 0.38f, 1.21f, 1.22f, 1.09f, 2.07f)
                lineToRelative(-0.63f, 4.46f)
                curveTo(22.21f, 22.27f, 21.36f, 23.0f, 20.37f, 23.0f)
                horizontalLineToRelative(-6.16f)
                curveToRelative(-0.53f, 0.0f, -1.29f, -0.21f, -1.66f, -0.59f)
                lineToRelative(-4.07f, -4.29f)
                curveTo(8.3f, 17.94f, 8.2f, 17.69f, 8.2f, 17.43f)
                close()
                moveTo(9.5f, 5.25f)
                curveTo(9.5f, 5.66f, 9.84f, 6.0f, 10.25f, 6.0f)
                reflectiveCurveTo(11.0f, 5.66f, 11.0f, 5.25f)
                verticalLineTo(2.0f)
                curveToRelative(0.0f, -0.55f, -0.45f, -1.0f, -1.0f, -1.0f)
                horizontalLineTo(6.75f)
                curveTo(6.34f, 1.0f, 6.0f, 1.34f, 6.0f, 1.75f)
                reflectiveCurveTo(6.34f, 2.5f, 6.75f, 2.5f)
                horizontalLineToRelative(1.69f)
                lineTo(2.5f, 8.44f)
                verticalLineTo(6.75f)
                curveTo(2.5f, 6.34f, 2.16f, 6.0f, 1.75f, 6.0f)
                reflectiveCurveTo(1.0f, 6.34f, 1.0f, 6.75f)
                verticalLineTo(10.0f)
                curveToRelative(0.0f, 0.55f, 0.45f, 1.0f, 1.0f, 1.0f)
                horizontalLineToRelative(3.25f)
                curveTo(5.66f, 11.0f, 6.0f, 10.66f, 6.0f, 10.25f)
                reflectiveCurveTo(5.66f, 9.5f, 5.25f, 9.5f)
                horizontalLineTo(3.56f)
                lineTo(9.5f, 3.56f)
                verticalLineTo(5.25f)
                close()
            }
        }
        return _pinch!!
    }

private var _pinch: ImageVector? = null
