/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.Fireplace: ImageVector
    get() {
        if (_fireplace != null) {
            return _fireplace!!
        }
        _fireplace = materialIcon(name = "Sharp.Fireplace") {
            materialPath {
                moveTo(2.0f, 2.0f)
                verticalLineToRelative(20.0f)
                horizontalLineToRelative(20.0f)
                verticalLineTo(2.0f)
                horizontalLineTo(2.0f)
                close()
                moveTo(13.2f, 13.74f)
                curveToRelative(-0.08f, -0.46f, -0.07f, -0.85f, 0.08f, -1.28f)
                curveToRelative(0.54f, 1.21f, 2.15f, 1.64f, 1.98f, 3.18f)
                curveToRelative(-0.19f, 1.69f, -2.11f, 2.37f, -3.39f, 1.32f)
                curveToRelative(0.76f, -0.24f, 1.4f, -1.04f, 1.53f, -1.63f)
                curveTo(13.52f, 14.78f, 13.29f, 14.29f, 13.2f, 13.74f)
                close()
                moveTo(20.0f, 20.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineToRelative(-2.0f)
                horizontalLineToRelative(-2.02f)
                curveToRelative(0.63f, -0.84f, 1.02f, -1.87f, 1.02f, -3.0f)
                curveToRelative(0.0f, -1.89f, -1.09f, -2.85f, -1.85f, -3.37f)
                curveTo(12.2f, 9.61f, 13.0f, 7.0f, 13.0f, 7.0f)
                curveToRelative(-6.73f, 3.57f, -6.02f, 7.47f, -6.0f, 8.0f)
                curveToRelative(0.03f, 0.96f, 0.49f, 2.07f, 1.23f, 3.0f)
                horizontalLineTo(6.0f)
                verticalLineToRelative(2.0f)
                horizontalLineTo(4.0f)
                verticalLineTo(4.0f)
                horizontalLineToRelative(16.0f)
                verticalLineTo(20.0f)
                close()
            }
        }
        return _fireplace!!
    }

private var _fireplace: ImageVector? = null
