/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.PowerOff: ImageVector
    get() {
        if (_powerOff != null) {
            return _powerOff!!
        }
        _powerOff = materialIcon(name = "Sharp.PowerOff") {
            materialPath {
                moveTo(18.0f, 14.49f)
                lineTo(18.0f, 9.0f)
                curveToRelative(0.0f, -1.1f, -0.9f, -2.0f, -2.0f, -2.0f)
                lineTo(16.0f, 3.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineToRelative(4.0f)
                horizontalLineToRelative(-3.88f)
                lineToRelative(7.69f, 7.69f)
                lineToRelative(0.19f, -0.2f)
                close()
                moveTo(10.0f, 3.0f)
                lineTo(8.0f, 3.0f)
                verticalLineToRelative(1.88f)
                lineToRelative(2.0f, 2.0f)
                close()
                moveTo(4.12f, 3.84f)
                lineTo(2.71f, 5.25f)
                lineToRelative(3.34f, 3.34f)
                curveToRelative(-0.03f, 0.13f, -0.05f, 0.27f, -0.05f, 0.4f)
                verticalLineToRelative(5.51f)
                lineTo(9.5f, 18.0f)
                verticalLineToRelative(3.0f)
                horizontalLineToRelative(5.0f)
                verticalLineToRelative(-3.0f)
                lineToRelative(0.48f, -0.48f)
                lineToRelative(4.47f, 4.47f)
                lineToRelative(1.41f, -1.41f)
                lineTo(4.12f, 3.84f)
                close()
            }
        }
        return _powerOff!!
    }

private var _powerOff: ImageVector? = null
