/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.SwipeUp: ImageVector
    get() {
        if (_swipeUp != null) {
            return _swipeUp!!
        }
        _swipeUp = materialIcon(name = "Sharp.SwipeUp") {
            materialPath {
                moveTo(2.06f, 5.56f)
                lineTo(1.0f, 4.5f)
                lineTo(4.5f, 1.0f)
                lineTo(8.0f, 4.5f)
                lineTo(6.94f, 5.56f)
                lineTo(5.32f, 3.94f)
                curveTo(5.11f, 4.76f, 5.0f, 5.62f, 5.0f, 6.5f)
                curveToRelative(0.0f, 2.42f, 0.82f, 4.65f, 2.2f, 6.43f)
                lineTo(6.13f, 14.0f)
                curveTo(4.49f, 11.95f, 3.5f, 9.34f, 3.5f, 6.5f)
                curveToRelative(0.0f, -0.92f, 0.1f, -1.82f, 0.3f, -2.68f)
                lineTo(2.06f, 5.56f)
                close()
                moveTo(21.71f, 11.18f)
                lineToRelative(2.09f, 7.39f)
                lineToRelative(-8.23f, 3.65f)
                lineToRelative(-6.84f, -2.85f)
                lineToRelative(0.61f, -1.62f)
                lineToRelative(3.8f, -0.75f)
                lineTo(8.79f, 7.17f)
                curveToRelative(-0.34f, -0.76f, 0.0f, -1.64f, 0.76f, -1.98f)
                curveToRelative(0.76f, -0.34f, 1.64f, 0.0f, 1.98f, 0.76f)
                lineToRelative(2.43f, 5.49f)
                lineToRelative(1.26f, -0.56f)
                lineTo(21.71f, 11.18f)
                close()
            }
        }
        return _swipeUp!!
    }

private var _swipeUp: ImageVector? = null
