/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.Wash: ImageVector
    get() {
        if (_wash != null) {
            return _wash!!
        }
        _wash = materialIcon(name = "Sharp.Wash") {
            materialPath {
                moveTo(9.12f, 5.0f)
                lineTo(1.0f, 12.68f)
                verticalLineTo(23.0f)
                horizontalLineToRelative(18.0f)
                verticalLineToRelative(-2.5f)
                horizontalLineToRelative(-7.0f)
                verticalLineToRelative(-1.0f)
                horizontalLineToRelative(9.0f)
                verticalLineTo(17.0f)
                horizontalLineToRelative(-9.0f)
                verticalLineToRelative(-1.0f)
                horizontalLineToRelative(10.0f)
                verticalLineToRelative(-2.5f)
                horizontalLineTo(12.0f)
                verticalLineToRelative(-1.0f)
                horizontalLineToRelative(8.0f)
                verticalLineTo(10.0f)
                horizontalLineTo(8.86f)
                lineToRelative(1.88f, -3.3f)
                lineTo(9.12f, 5.0f)
                lineTo(9.12f, 5.0f)
                close()
                moveTo(13.5f, 9.0f)
                curveTo(14.33f, 9.0f, 15.0f, 8.33f, 15.0f, 7.5f)
                curveTo(15.0f, 6.66f, 13.5f, 5.0f, 13.5f, 5.0f)
                reflectiveCurveTo(12.0f, 6.66f, 12.0f, 7.5f)
                curveTo(12.0f, 8.33f, 12.67f, 9.0f, 13.5f, 9.0f)
                close()
                moveTo(18.5f, 1.0f)
                curveToRelative(0.0f, 0.0f, -2.5f, 2.83f, -2.5f, 4.5f)
                curveTo(16.0f, 6.88f, 17.12f, 8.0f, 18.5f, 8.0f)
                reflectiveCurveTo(21.0f, 6.88f, 21.0f, 5.5f)
                curveTo(21.0f, 3.83f, 18.5f, 1.0f, 18.5f, 1.0f)
                close()
            }
        }
        return _wash!!
    }

private var _wash: ImageVector? = null
