/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.Map: ImageVector
    get() {
        if (_map != null) {
            return _map!!
        }
        _map = materialIcon(name = "TwoTone.Map") {
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(5.0f, 18.31f)
                lineToRelative(3.0f, -1.16f)
                lineTo(8.0f, 5.45f)
                lineTo(5.0f, 6.46f)
                close()
                moveTo(16.0f, 18.55f)
                lineToRelative(3.0f, -1.01f)
                lineTo(19.0f, 5.69f)
                lineToRelative(-3.0f, 1.17f)
                close()
            }
            materialPath {
                moveTo(20.5f, 3.0f)
                lineToRelative(-0.16f, 0.03f)
                lineTo(15.0f, 5.1f)
                lineTo(9.0f, 3.0f)
                lineTo(3.36f, 4.9f)
                curveToRelative(-0.21f, 0.07f, -0.36f, 0.25f, -0.36f, 0.48f)
                lineTo(3.0f, 20.5f)
                curveToRelative(0.0f, 0.28f, 0.22f, 0.5f, 0.5f, 0.5f)
                lineToRelative(0.16f, -0.03f)
                lineTo(9.0f, 18.9f)
                lineToRelative(6.0f, 2.1f)
                lineToRelative(5.64f, -1.9f)
                curveToRelative(0.21f, -0.07f, 0.36f, -0.25f, 0.36f, -0.48f)
                lineTo(21.0f, 3.5f)
                curveToRelative(0.0f, -0.28f, -0.22f, -0.5f, -0.5f, -0.5f)
                close()
                moveTo(8.0f, 17.15f)
                lineToRelative(-3.0f, 1.16f)
                lineTo(5.0f, 6.46f)
                lineToRelative(3.0f, -1.01f)
                verticalLineToRelative(11.7f)
                close()
                moveTo(14.0f, 18.53f)
                lineToRelative(-4.0f, -1.4f)
                lineTo(10.0f, 5.47f)
                lineToRelative(4.0f, 1.4f)
                verticalLineToRelative(11.66f)
                close()
                moveTo(19.0f, 17.54f)
                lineToRelative(-3.0f, 1.01f)
                lineTo(16.0f, 6.86f)
                lineToRelative(3.0f, -1.16f)
                verticalLineToRelative(11.84f)
                close()
            }
        }
        return _map!!
    }

private var _map: ImageVector? = null
