/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.BroadcastOnPersonal: ImageVector
    get() {
        if (_broadcastOnPersonal != null) {
            return _broadcastOnPersonal!!
        }
        _broadcastOnPersonal = materialIcon(name = "Rounded.BroadcastOnPersonal") {
            materialPath {
                moveTo(17.0f, 8.0f)
                curveToRelative(0.7f, 0.0f, 1.38f, 0.1f, 2.02f, 0.27f)
                lineTo(12.0f, 3.0f)
                lineTo(4.0f, 9.0f)
                verticalLineToRelative(12.0f)
                horizontalLineToRelative(6.76f)
                curveTo(9.66f, 19.63f, 9.0f, 17.89f, 9.0f, 16.0f)
                curveTo(9.0f, 11.58f, 12.58f, 8.0f, 17.0f, 8.0f)
                close()
            }
            materialPath {
                moveTo(17.0f, 14.75f)
                curveToRelative(-0.69f, 0.0f, -1.25f, 0.56f, -1.25f, 1.25f)
                curveToRelative(0.0f, 0.4f, 0.2f, 0.75f, 0.5f, 0.97f)
                verticalLineTo(22.0f)
                horizontalLineToRelative(1.5f)
                verticalLineToRelative(-5.03f)
                curveToRelative(0.3f, -0.23f, 0.5f, -0.57f, 0.5f, -0.97f)
                curveTo(18.25f, 15.31f, 17.69f, 14.75f, 17.0f, 14.75f)
                close()
            }
            materialPath {
                moveTo(17.0f, 12.0f)
                curveToRelative(-2.21f, 0.0f, -4.0f, 1.79f, -4.0f, 4.0f)
                curveToRelative(0.0f, 1.1f, 0.45f, 2.1f, 1.17f, 2.83f)
                lineToRelative(1.06f, -1.06f)
                curveToRelative(-0.45f, -0.45f, -0.73f, -1.08f, -0.73f, -1.77f)
                curveToRelative(0.0f, -1.38f, 1.12f, -2.5f, 2.5f, -2.5f)
                reflectiveCurveToRelative(2.5f, 1.12f, 2.5f, 2.5f)
                curveToRelative(0.0f, 0.69f, -0.28f, 1.31f, -0.73f, 1.76f)
                lineToRelative(1.06f, 1.06f)
                curveTo(20.55f, 18.1f, 21.0f, 17.1f, 21.0f, 16.0f)
                curveTo(21.0f, 13.79f, 19.21f, 12.0f, 17.0f, 12.0f)
                close()
            }
            materialPath {
                moveTo(17.0f, 9.5f)
                curveToRelative(-3.59f, 0.0f, -6.5f, 2.91f, -6.5f, 6.5f)
                curveToRelative(0.0f, 1.79f, 0.73f, 3.42f, 1.9f, 4.6f)
                lineToRelative(1.06f, -1.06f)
                curveTo(12.56f, 18.63f, 12.0f, 17.38f, 12.0f, 16.0f)
                curveToRelative(0.0f, -2.76f, 2.24f, -5.0f, 5.0f, -5.0f)
                reflectiveCurveToRelative(5.0f, 2.24f, 5.0f, 5.0f)
                curveToRelative(0.0f, 1.37f, -0.56f, 2.62f, -1.46f, 3.52f)
                lineToRelative(1.07f, 1.06f)
                curveToRelative(1.17f, -1.18f, 1.89f, -2.8f, 1.89f, -4.58f)
                curveTo(23.5f, 12.41f, 20.59f, 9.5f, 17.0f, 9.5f)
                close()
            }
        }
        return _broadcastOnPersonal!!
    }

private var _broadcastOnPersonal: ImageVector? = null
