/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Outlined.Hub: ImageVector
    get() {
        if (_hub != null) {
            return _hub!!
        }
        _hub = materialIcon(name = "Outlined.Hub") {
            materialPath {
                moveTo(21.0f, 6.5f)
                curveToRelative(-1.66f, 0.0f, -3.0f, 1.34f, -3.0f, 3.0f)
                curveToRelative(0.0f, 0.07f, 0.0f, 0.14f, 0.01f, 0.21f)
                lineToRelative(-2.03f, 0.68f)
                curveToRelative(-0.64f, -1.21f, -1.82f, -2.09f, -3.22f, -2.32f)
                verticalLineTo(5.91f)
                curveTo(14.04f, 5.57f, 15.0f, 4.4f, 15.0f, 3.0f)
                curveToRelative(0.0f, -1.66f, -1.34f, -3.0f, -3.0f, -3.0f)
                reflectiveCurveTo(9.0f, 1.34f, 9.0f, 3.0f)
                curveToRelative(0.0f, 1.4f, 0.96f, 2.57f, 2.25f, 2.91f)
                verticalLineToRelative(2.16f)
                curveToRelative(-1.4f, 0.23f, -2.58f, 1.11f, -3.22f, 2.32f)
                lineTo(5.99f, 9.71f)
                curveTo(6.0f, 9.64f, 6.0f, 9.57f, 6.0f, 9.5f)
                curveToRelative(0.0f, -1.66f, -1.34f, -3.0f, -3.0f, -3.0f)
                reflectiveCurveToRelative(-3.0f, 1.34f, -3.0f, 3.0f)
                reflectiveCurveToRelative(1.34f, 3.0f, 3.0f, 3.0f)
                curveToRelative(1.06f, 0.0f, 1.98f, -0.55f, 2.52f, -1.37f)
                lineToRelative(2.03f, 0.68f)
                curveToRelative(-0.2f, 1.29f, 0.17f, 2.66f, 1.09f, 3.69f)
                lineToRelative(-1.41f, 1.77f)
                curveTo(6.85f, 17.09f, 6.44f, 17.0f, 6.0f, 17.0f)
                curveToRelative(-1.66f, 0.0f, -3.0f, 1.34f, -3.0f, 3.0f)
                reflectiveCurveToRelative(1.34f, 3.0f, 3.0f, 3.0f)
                reflectiveCurveToRelative(3.0f, -1.34f, 3.0f, -3.0f)
                curveToRelative(0.0f, -0.68f, -0.22f, -1.3f, -0.6f, -1.8f)
                lineToRelative(1.41f, -1.77f)
                curveToRelative(1.36f, 0.76f, 3.02f, 0.75f, 4.37f, 0.0f)
                lineToRelative(1.41f, 1.77f)
                curveTo(15.22f, 18.7f, 15.0f, 19.32f, 15.0f, 20.0f)
                curveToRelative(0.0f, 1.66f, 1.34f, 3.0f, 3.0f, 3.0f)
                reflectiveCurveToRelative(3.0f, -1.34f, 3.0f, -3.0f)
                reflectiveCurveToRelative(-1.34f, -3.0f, -3.0f, -3.0f)
                curveToRelative(-0.44f, 0.0f, -0.85f, 0.09f, -1.23f, 0.26f)
                lineToRelative(-1.41f, -1.77f)
                curveToRelative(0.93f, -1.04f, 1.29f, -2.4f, 1.09f, -3.69f)
                lineToRelative(2.03f, -0.68f)
                curveToRelative(0.53f, 0.82f, 1.46f, 1.37f, 2.52f, 1.37f)
                curveToRelative(1.66f, 0.0f, 3.0f, -1.34f, 3.0f, -3.0f)
                reflectiveCurveTo(22.66f, 6.5f, 21.0f, 6.5f)
                close()
                moveTo(3.0f, 10.5f)
                curveToRelative(-0.55f, 0.0f, -1.0f, -0.45f, -1.0f, -1.0f)
                curveToRelative(0.0f, -0.55f, 0.45f, -1.0f, 1.0f, -1.0f)
                reflectiveCurveToRelative(1.0f, 0.45f, 1.0f, 1.0f)
                curveTo(4.0f, 10.05f, 3.55f, 10.5f, 3.0f, 10.5f)
                close()
                moveTo(6.0f, 21.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, -0.45f, -1.0f, -1.0f)
                curveToRelative(0.0f, -0.55f, 0.45f, -1.0f, 1.0f, -1.0f)
                reflectiveCurveToRelative(1.0f, 0.45f, 1.0f, 1.0f)
                curveTo(7.0f, 20.55f, 6.55f, 21.0f, 6.0f, 21.0f)
                close()
                moveTo(11.0f, 3.0f)
                curveToRelative(0.0f, -0.55f, 0.45f, -1.0f, 1.0f, -1.0f)
                reflectiveCurveToRelative(1.0f, 0.45f, 1.0f, 1.0f)
                curveToRelative(0.0f, 0.55f, -0.45f, 1.0f, -1.0f, 1.0f)
                reflectiveCurveTo(11.0f, 3.55f, 11.0f, 3.0f)
                close()
                moveTo(12.0f, 15.0f)
                curveToRelative(-1.38f, 0.0f, -2.5f, -1.12f, -2.5f, -2.5f)
                curveToRelative(0.0f, -1.38f, 1.12f, -2.5f, 2.5f, -2.5f)
                reflectiveCurveToRelative(2.5f, 1.12f, 2.5f, 2.5f)
                curveTo(14.5f, 13.88f, 13.38f, 15.0f, 12.0f, 15.0f)
                close()
                moveTo(18.0f, 19.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, 0.45f, 1.0f, 1.0f)
                curveToRelative(0.0f, 0.55f, -0.45f, 1.0f, -1.0f, 1.0f)
                reflectiveCurveToRelative(-1.0f, -0.45f, -1.0f, -1.0f)
                curveTo(17.0f, 19.45f, 17.45f, 19.0f, 18.0f, 19.0f)
                close()
                moveTo(21.0f, 10.5f)
                curveToRelative(-0.55f, 0.0f, -1.0f, -0.45f, -1.0f, -1.0f)
                curveToRelative(0.0f, -0.55f, 0.45f, -1.0f, 1.0f, -1.0f)
                reflectiveCurveToRelative(1.0f, 0.45f, 1.0f, 1.0f)
                curveTo(22.0f, 10.05f, 21.55f, 10.5f, 21.0f, 10.5f)
                close()
            }
        }
        return _hub!!
    }

private var _hub: ImageVector? = null
