/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Outlined.SportsKabaddi: ImageVector
    get() {
        if (_sportsKabaddi != null) {
            return _sportsKabaddi!!
        }
        _sportsKabaddi = materialIcon(name = "Outlined.SportsKabaddi") {
            materialPath {
                moveTo(16.5f, 2.38f)
                moveToRelative(-2.0f, 0.0f)
                arcToRelative(2.0f, 2.0f, 0.0f, true, true, 4.0f, 0.0f)
                arcToRelative(2.0f, 2.0f, 0.0f, true, true, -4.0f, 0.0f)
            }
            materialPath {
                moveTo(24.0f, 11.88f)
                verticalLineToRelative(-4.7f)
                lineToRelative(-5.05f, -2.14f)
                curveToRelative(-0.97f, -0.41f, -2.09f, -0.06f, -2.65f, 0.84f)
                lineToRelative(0.0f, 0.0f)
                lineToRelative(-1.0f, 1.6f)
                curveToRelative(-0.67f, 1.18f, -1.91f, 2.06f, -3.41f, 2.32f)
                lineToRelative(0.06f, 0.06f)
                curveToRelative(0.69f, 0.69f, 1.52f, 1.07f, 2.46f, 1.17f)
                curveToRelative(0.8f, -0.42f, 1.52f, -0.98f, 2.09f, -1.64f)
                lineToRelative(0.6f, 3.0f)
                lineToRelative(-1.16f, 1.1f)
                lineTo(15.0f, 14.38f)
                verticalLineToRelative(0.76f)
                verticalLineToRelative(6.74f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(-6.0f)
                lineToRelative(2.1f, -2.0f)
                lineToRelative(1.8f, 8.0f)
                horizontalLineTo(23.0f)
                lineToRelative(-2.18f, -11.0f)
                lineToRelative(-0.62f, -3.1f)
                lineToRelative(1.8f, 0.7f)
                verticalLineToRelative(3.4f)
                horizontalLineTo(24.0f)
                close()
            }
            materialPath {
                moveTo(10.29f, 8.09f)
                curveToRelative(0.22f, 0.15f, 0.47f, 0.24f, 0.72f, 0.29f)
                curveToRelative(0.13f, 0.02f, 0.25f, 0.04f, 0.38f, 0.04f)
                reflectiveCurveToRelative(0.26f, -0.01f, 0.38f, -0.04f)
                curveToRelative(0.13f, -0.02f, 0.25f, -0.06f, 0.37f, -0.11f)
                curveToRelative(0.24f, -0.1f, 0.47f, -0.24f, 0.66f, -0.44f)
                curveToRelative(0.49f, -0.49f, 0.67f, -1.17f, 0.55f, -1.8f)
                curveTo(13.28f, 5.66f, 13.1f, 5.29f, 12.8f, 5.0f)
                curveToRelative(-0.19f, -0.19f, -0.42f, -0.34f, -0.66f, -0.44f)
                curveToRelative(-0.12f, -0.05f, -0.24f, -0.09f, -0.37f, -0.11f)
                reflectiveCurveToRelative(-0.25f, -0.04f, -0.38f, -0.04f)
                curveToRelative(-0.12f, 0.0f, -0.23f, 0.01f, -0.35f, 0.03f)
                curveToRelative(-0.14f, 0.02f, -0.28f, 0.06f, -0.41f, 0.11f)
                curveTo(10.4f, 4.66f, 10.17f, 4.81f, 9.98f, 5.0f)
                curveTo(9.68f, 5.29f, 9.5f, 5.66f, 9.43f, 6.03f)
                curveToRelative(-0.12f, 0.63f, 0.06f, 1.31f, 0.55f, 1.8f)
                curveTo(10.07f, 7.93f, 10.18f, 8.01f, 10.29f, 8.09f)
                close()
            }
            materialPath {
                moveTo(11.24f, 10.56f)
                lineToRelative(-2.0f, -2.0f)
                curveToRelative(-0.1f, -0.1f, -0.2f, -0.18f, -0.31f, -0.26f)
                curveTo(8.71f, 8.16f, 8.46f, 8.06f, 8.21f, 8.02f)
                curveTo(8.08f, 7.99f, 7.96f, 7.98f, 7.83f, 7.98f)
                curveToRelative(-0.51f, 0.0f, -1.02f, 0.2f, -1.41f, 0.59f)
                lineToRelative(-3.34f, 3.34f)
                curveToRelative(-0.41f, 0.41f, -0.62f, 0.98f, -0.58f, 1.54f)
                curveTo(2.5f, 13.63f, 2.54f, 13.82f, 2.61f, 14.0f)
                lineToRelative(1.07f, 2.95f)
                lineToRelative(-3.63f, 3.63f)
                lineTo(1.46f, 22.0f)
                lineToRelative(4.24f, -4.24f)
                verticalLineToRelative(-2.22f)
                lineTo(7.0f, 16.75f)
                verticalLineToRelative(5.13f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(-6.0f)
                lineToRelative(-2.12f, -2.12f)
                lineToRelative(2.36f, -2.36f)
                lineToRelative(0.71f, 0.71f)
                lineToRelative(0.0f, 0.0f)
                curveToRelative(1.29f, 1.26f, 2.97f, 2.04f, 5.03f, 2.04f)
                lineToRelative(-0.14f, -2.07f)
                curveTo(13.34f, 12.06f, 12.14f, 11.46f, 11.24f, 10.56f)
                close()
            }
        }
        return _sportsKabaddi!!
    }

private var _sportsKabaddi: ImageVector? = null
