/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.Extension: ImageVector
    get() {
        if (_extension != null) {
            return _extension!!
        }
        _extension = materialIcon(name = "Sharp.Extension") {
            materialPath {
                moveTo(20.36f, 11.0f)
                horizontalLineTo(19.0f)
                verticalLineTo(5.0f)
                horizontalLineToRelative(-6.0f)
                verticalLineTo(3.64f)
                curveToRelative(0.0f, -1.31f, -0.94f, -2.5f, -2.24f, -2.63f)
                curveTo(9.26f, 0.86f, 8.0f, 2.03f, 8.0f, 3.5f)
                verticalLineTo(5.0f)
                horizontalLineTo(2.01f)
                verticalLineToRelative(5.8f)
                horizontalLineTo(3.4f)
                curveToRelative(1.31f, 0.0f, 2.5f, 0.88f, 2.75f, 2.16f)
                curveToRelative(0.33f, 1.72f, -0.98f, 3.24f, -2.65f, 3.24f)
                horizontalLineTo(2.0f)
                verticalLineTo(22.0f)
                horizontalLineToRelative(5.8f)
                verticalLineToRelative(-1.4f)
                curveToRelative(0.0f, -1.31f, 0.88f, -2.5f, 2.16f, -2.75f)
                curveToRelative(1.72f, -0.33f, 3.24f, 0.98f, 3.24f, 2.65f)
                verticalLineTo(22.0f)
                horizontalLineTo(19.0f)
                verticalLineToRelative(-6.0f)
                horizontalLineToRelative(1.5f)
                curveToRelative(1.47f, 0.0f, 2.64f, -1.26f, 2.49f, -2.76f)
                curveToRelative(-0.13f, -1.3f, -1.33f, -2.24f, -2.63f, -2.24f)
                close()
            }
        }
        return _extension!!
    }

private var _extension: ImageVector? = null
