/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.ElectricalServices: ImageVector
    get() {
        if (_electricalServices != null) {
            return _electricalServices!!
        }
        _electricalServices = materialIcon(name = "TwoTone.ElectricalServices") {
            materialPath {
                moveTo(20.0f, 15.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineToRelative(-2.0f)
                horizontalLineToRelative(2.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, 0.45f, 1.0f, 1.0f)
                verticalLineToRelative(0.0f)
                curveTo(21.0f, 14.55f, 20.55f, 15.0f, 20.0f, 15.0f)
                close()
            }
            materialPath {
                moveTo(20.0f, 19.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineToRelative(-2.0f)
                horizontalLineToRelative(2.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, 0.45f, 1.0f, 1.0f)
                verticalLineToRelative(0.0f)
                curveTo(21.0f, 18.55f, 20.55f, 19.0f, 20.0f, 19.0f)
                close()
            }
            materialPath {
                moveTo(14.0f, 12.0f)
                lineTo(14.0f, 12.0f)
                lineTo(14.0f, 12.0f)
                curveToRelative(-1.1f, 0.0f, -2.0f, 0.9f, -2.0f, 2.0f)
                verticalLineToRelative(0.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineToRelative(4.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(0.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(0.0f)
                horizontalLineToRelative(3.0f)
                lineToRelative(0.0f, 0.0f)
                verticalLineToRelative(-8.0f)
                horizontalLineTo(14.0f)
                close()
            }
            materialPath {
                moveTo(4.0f, 5.0f)
                lineTo(4.0f, 5.0f)
                curveToRelative(0.0f, 0.55f, 0.45f, 1.0f, 1.0f, 1.0f)
                horizontalLineToRelative(3.5f)
                curveTo(9.33f, 6.0f, 10.0f, 6.67f, 10.0f, 7.5f)
                verticalLineToRelative(0.0f)
                curveTo(10.0f, 8.33f, 9.33f, 9.0f, 8.5f, 9.0f)
                horizontalLineTo(7.0f)
                curveToRelative(-2.21f, 0.0f, -4.0f, 1.79f, -4.0f, 4.0f)
                verticalLineToRelative(0.0f)
                curveToRelative(0.0f, 2.21f, 1.79f, 4.0f, 4.0f, 4.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(-2.0f)
                horizontalLineTo(7.0f)
                curveToRelative(-1.1f, 0.0f, -2.0f, -0.9f, -2.0f, -2.0f)
                verticalLineToRelative(0.0f)
                curveToRelative(0.0f, -1.1f, 0.9f, -2.0f, 2.0f, -2.0f)
                horizontalLineToRelative(1.5f)
                curveToRelative(1.93f, 0.0f, 3.5f, -1.57f, 3.5f, -3.5f)
                verticalLineToRelative(0.0f)
                curveTo(12.0f, 5.57f, 10.43f, 4.0f, 8.5f, 4.0f)
                horizontalLineTo(5.0f)
                curveTo(4.45f, 4.0f, 4.0f, 4.45f, 4.0f, 5.0f)
                close()
            }
        }
        return _electricalServices!!
    }

private var _electricalServices: ImageVector? = null
