/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.Escalator: ImageVector
    get() {
        if (_escalator != null) {
            return _escalator!!
        }
        _escalator = materialIcon(name = "TwoTone.Escalator") {
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(19.0f, 5.0f)
                lineTo(19.0f, 5.0f)
                lineToRelative(0.0f, 14.0f)
                horizontalLineTo(5.0f)
                verticalLineTo(5.0f)
                horizontalLineTo(19.0f)
                moveTo(17.0f, 6.0f)
                horizontalLineToRelative(-3.3f)
                lineToRelative(-5.0f, 9.0f)
                horizontalLineTo(7.0f)
                curveToRelative(-0.83f, 0.0f, -1.5f, 0.67f, -1.5f, 1.5f)
                reflectiveCurveTo(6.17f, 18.0f, 7.0f, 18.0f)
                horizontalLineToRelative(3.3f)
                lineToRelative(5.0f, -9.0f)
                horizontalLineTo(17.0f)
                curveToRelative(0.83f, 0.0f, 1.5f, -0.67f, 1.5f, -1.5f)
                reflectiveCurveTo(17.83f, 6.0f, 17.0f, 6.0f)
                close()
            }
            materialPath {
                moveTo(19.0f, 5.0f)
                lineTo(19.0f, 5.0f)
                lineToRelative(0.0f, 14.0f)
                horizontalLineTo(5.0f)
                verticalLineTo(5.0f)
                horizontalLineTo(19.0f)
                moveTo(19.0f, 3.0f)
                horizontalLineTo(5.0f)
                curveTo(3.9f, 3.0f, 3.0f, 3.9f, 3.0f, 5.0f)
                verticalLineToRelative(14.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(14.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                lineToRelative(0.0f, -14.0f)
                curveTo(21.0f, 3.9f, 20.1f, 3.0f, 19.0f, 3.0f)
                lineTo(19.0f, 3.0f)
                close()
                moveTo(17.0f, 6.0f)
                horizontalLineToRelative(-3.3f)
                lineToRelative(-5.0f, 9.0f)
                horizontalLineTo(7.0f)
                curveToRelative(-0.83f, 0.0f, -1.5f, 0.67f, -1.5f, 1.5f)
                reflectiveCurveTo(6.17f, 18.0f, 7.0f, 18.0f)
                horizontalLineToRelative(3.3f)
                lineToRelative(5.0f, -9.0f)
                horizontalLineTo(17.0f)
                curveToRelative(0.83f, 0.0f, 1.5f, -0.67f, 1.5f, -1.5f)
                reflectiveCurveTo(17.83f, 6.0f, 17.0f, 6.0f)
                close()
            }
        }
        return _escalator!!
    }

private var _escalator: ImageVector? = null
