/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.LeaveBagsAtHome: ImageVector
    get() {
        if (_leaveBagsAtHome != null) {
            return _leaveBagsAtHome!!
        }
        _leaveBagsAtHome = materialIcon(name = "TwoTone.LeaveBagsAtHome") {
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(7.0f, 19.0f)
                verticalLineTo(9.83f)
                lineToRelative(1.0f, 1.0f)
                verticalLineTo(18.0f)
                horizontalLineToRelative(1.5f)
                verticalLineToRelative(-5.67f)
                lineToRelative(1.75f, 1.75f)
                verticalLineTo(18.0f)
                horizontalLineToRelative(1.5f)
                verticalLineToRelative(-2.42f)
                lineToRelative(1.75f, 1.75f)
                verticalLineTo(18.0f)
                horizontalLineToRelative(0.67f)
                lineToRelative(1.0f, 1.0f)
                horizontalLineTo(7.0f)
                close()
                moveTo(10.83f, 8.0f)
                lineToRelative(1.0f, 1.0f)
                horizontalLineToRelative(0.92f)
                verticalLineToRelative(0.92f)
                lineToRelative(1.75f, 1.75f)
                verticalLineTo(9.0f)
                horizontalLineTo(16.0f)
                verticalLineToRelative(4.17f)
                lineToRelative(0.0f, 0.0f)
                lineToRelative(1.0f, 1.0f)
                verticalLineTo(8.0f)
                horizontalLineTo(10.83f)
                close()
            }
            materialPath {
                moveTo(10.83f, 8.0f)
                horizontalLineTo(17.0f)
                verticalLineToRelative(6.17f)
                lineToRelative(2.0f, 2.0f)
                verticalLineTo(8.0f)
                curveToRelative(0.0f, -1.1f, -0.9f, -2.0f, -2.0f, -2.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineTo(3.0f)
                curveToRelative(0.0f, -0.55f, -0.45f, -1.0f, -1.0f, -1.0f)
                horizontalLineToRelative(-4.0f)
                curveTo(9.45f, 2.0f, 9.0f, 2.45f, 9.0f, 3.0f)
                verticalLineToRelative(3.0f)
                horizontalLineTo(8.83f)
                lineTo(10.83f, 8.0f)
                close()
                moveTo(11.0f, 4.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineTo(4.0f)
                close()
                moveTo(11.83f, 9.0f)
                horizontalLineToRelative(0.92f)
                verticalLineToRelative(0.92f)
                lineTo(11.83f, 9.0f)
                close()
                moveTo(21.19f, 21.19f)
                lineTo(2.81f, 2.81f)
                lineTo(1.39f, 4.22f)
                lineToRelative(3.63f, 3.63f)
                curveTo(5.02f, 7.9f, 5.0f, 7.95f, 5.0f, 8.0f)
                verticalLineToRelative(11.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                curveToRelative(0.0f, 0.55f, 0.45f, 1.0f, 1.0f, 1.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, -0.45f, 1.0f, -1.0f)
                horizontalLineToRelative(6.0f)
                curveToRelative(0.0f, 0.55f, 0.45f, 1.0f, 1.0f, 1.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, -0.45f, 1.0f, -1.0f)
                curveToRelative(0.34f, 0.0f, 0.65f, -0.09f, 0.93f, -0.24f)
                lineToRelative(1.85f, 1.85f)
                lineTo(21.19f, 21.19f)
                close()
                moveTo(7.0f, 19.0f)
                verticalLineTo(9.83f)
                lineToRelative(1.0f, 1.0f)
                verticalLineTo(18.0f)
                horizontalLineToRelative(1.5f)
                verticalLineToRelative(-5.67f)
                lineToRelative(1.75f, 1.75f)
                verticalLineTo(18.0f)
                horizontalLineToRelative(1.5f)
                verticalLineToRelative(-2.42f)
                lineToRelative(1.75f, 1.75f)
                verticalLineTo(18.0f)
                horizontalLineToRelative(0.67f)
                lineToRelative(1.0f, 1.0f)
                horizontalLineTo(7.0f)
                close()
                moveTo(16.0f, 9.0f)
                verticalLineToRelative(4.17f)
                lineToRelative(-1.5f, -1.5f)
                verticalLineTo(9.0f)
                horizontalLineTo(16.0f)
                close()
            }
        }
        return _leaveBagsAtHome!!
    }

private var _leaveBagsAtHome: ImageVector? = null
