/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.WifiChannel: ImageVector
    get() {
        if (_wifiChannel != null) {
            return _wifiChannel!!
        }
        _wifiChannel = materialIcon(name = "Filled.WifiChannel") {
            materialPath {
                moveTo(16.0f, 3.0f)
                curveToRelative(-2.51f, 0.0f, -3.77f, 5.61f, -4.4f, 10.57f)
                curveTo(10.79f, 10.66f, 9.61f, 8.0f, 8.0f, 8.0f)
                curveTo(4.43f, 8.0f, 3.0f, 21.0f, 3.0f, 21.0f)
                horizontalLineToRelative(2.01f)
                curveToRelative(0.61f, -5.27f, 2.0f, -9.82f, 2.99f, -10.87f)
                curveToRelative(0.98f, 1.05f, 2.38f, 5.61f, 2.99f, 10.87f)
                horizontalLineTo(13.0f)
                curveToRelative(0.5f, -2.53f, 2.0f, -6.0f, 3.0f, -6.0f)
                reflectiveCurveToRelative(2.5f, 3.53f, 3.0f, 6.0f)
                horizontalLineToRelative(2.0f)
                curveTo(21.0f, 21.0f, 20.5f, 3.0f, 16.0f, 3.0f)
                close()
                moveTo(16.0f, 13.0f)
                curveToRelative(-0.99f, 0.0f, -1.82f, 0.62f, -2.5f, 1.5f)
                curveToRelative(0.57f, -4.77f, 1.54f, -8.62f, 2.5f, -9.44f)
                curveToRelative(0.97f, 0.81f, 1.91f, 4.67f, 2.49f, 9.43f)
                curveTo(17.81f, 13.62f, 16.98f, 13.0f, 16.0f, 13.0f)
                close()
            }
        }
        return _wifiChannel!!
    }

private var _wifiChannel: ImageVector? = null
