/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Outlined.BluetoothDisabled: ImageVector
    get() {
        if (_bluetoothDisabled != null) {
            return _bluetoothDisabled!!
        }
        _bluetoothDisabled = materialIcon(name = "Outlined.BluetoothDisabled") {
            materialPath {
                moveTo(13.0f, 5.83f)
                lineToRelative(1.88f, 1.88f)
                lineToRelative(-1.6f, 1.6f)
                lineToRelative(1.41f, 1.41f)
                lineToRelative(3.02f, -3.02f)
                lineTo(12.0f, 2.0f)
                horizontalLineToRelative(-1.0f)
                verticalLineToRelative(5.03f)
                lineToRelative(2.0f, 2.0f)
                verticalLineToRelative(-3.2f)
                close()
                moveTo(5.41f, 4.0f)
                lineTo(4.0f, 5.41f)
                lineTo(10.59f, 12.0f)
                lineTo(5.0f, 17.59f)
                lineTo(6.41f, 19.0f)
                lineTo(11.0f, 14.41f)
                verticalLineTo(22.0f)
                horizontalLineToRelative(1.0f)
                lineToRelative(4.29f, -4.29f)
                lineToRelative(2.3f, 2.29f)
                lineTo(20.0f, 18.59f)
                lineTo(5.41f, 4.0f)
                close()
                moveTo(13.0f, 18.17f)
                verticalLineToRelative(-3.76f)
                lineToRelative(1.88f, 1.88f)
                lineTo(13.0f, 18.17f)
                close()
            }
        }
        return _bluetoothDisabled!!
    }

private var _bluetoothDisabled: ImageVector? = null
