/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.Spa: ImageVector
    get() {
        if (_spa != null) {
            return _spa!!
        }
        _spa = materialIcon(name = "Rounded.Spa") {
            materialPath {
                moveTo(15.49f, 9.63f)
                curveToRelative(-0.16f, -2.42f, -1.03f, -4.79f, -2.64f, -6.76f)
                curveToRelative(-0.41f, -0.5f, -1.16f, -0.5f, -1.57f, 0.0f)
                curveToRelative(-1.65f, 1.98f, -2.57f, 4.35f, -2.77f, 6.76f)
                curveToRelative(1.28f, 0.68f, 2.46f, 1.56f, 3.49f, 2.63f)
                curveToRelative(1.03f, -1.06f, 2.21f, -1.94f, 3.49f, -2.63f)
                close()
                moveTo(8.99f, 12.28f)
                curveToRelative(-0.14f, -0.1f, -0.3f, -0.19f, -0.45f, -0.29f)
                curveToRelative(0.15f, 0.11f, 0.31f, 0.19f, 0.45f, 0.29f)
                close()
                moveTo(15.41f, 12.03f)
                curveToRelative(-0.13f, 0.09f, -0.27f, 0.16f, -0.4f, 0.26f)
                curveToRelative(0.13f, -0.1f, 0.27f, -0.17f, 0.4f, -0.26f)
                close()
                moveTo(12.0f, 15.45f)
                curveToRelative(-1.95f, -2.97f, -5.14f, -5.03f, -8.83f, -5.39f)
                curveToRelative(-0.64f, -0.06f, -1.17f, 0.47f, -1.11f, 1.11f)
                curveToRelative(0.45f, 4.8f, 3.65f, 8.78f, 7.98f, 10.33f)
                curveToRelative(0.63f, 0.23f, 1.29f, 0.4f, 1.97f, 0.51f)
                curveToRelative(0.68f, -0.12f, 1.33f, -0.29f, 1.97f, -0.51f)
                curveToRelative(4.33f, -1.55f, 7.53f, -5.52f, 7.98f, -10.33f)
                curveToRelative(0.06f, -0.64f, -0.48f, -1.17f, -1.11f, -1.11f)
                curveToRelative(-3.71f, 0.36f, -6.9f, 2.42f, -8.85f, 5.39f)
                close()
            }
        }
        return _spa!!
    }

private var _spa: ImageVector? = null
