/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.Forward5: ImageVector
    get() {
        if (_forward5 != null) {
            return _forward5!!
        }
        _forward5 = materialIcon(name = "TwoTone.Forward5") {
            materialPath {
                moveTo(17.95f, 13.0f)
                curveToRelative(0.0f, 3.31f, -2.69f, 6.0f, -6.0f, 6.0f)
                reflectiveCurveToRelative(-6.0f, -2.69f, -6.0f, -6.0f)
                reflectiveCurveToRelative(2.69f, -6.0f, 6.0f, -6.0f)
                verticalLineToRelative(4.0f)
                lineToRelative(5.0f, -5.0f)
                lineToRelative(-5.0f, -5.0f)
                verticalLineToRelative(4.0f)
                curveToRelative(-4.42f, 0.0f, -8.0f, 3.58f, -8.0f, 8.0f)
                reflectiveCurveToRelative(3.58f, 8.0f, 8.0f, 8.0f)
                reflectiveCurveToRelative(8.0f, -3.58f, 8.0f, -8.0f)
                horizontalLineToRelative(-2.0f)
                close()
                moveTo(12.43f, 15.15f)
                curveToRelative(-0.05f, 0.07f, -0.11f, 0.13f, -0.18f, 0.17f)
                reflectiveCurveToRelative(-0.17f, 0.06f, -0.27f, 0.06f)
                curveToRelative(-0.17f, 0.0f, -0.31f, -0.05f, -0.42f, -0.15f)
                reflectiveCurveToRelative(-0.17f, -0.24f, -0.19f, -0.41f)
                horizontalLineToRelative(-0.84f)
                curveToRelative(0.01f, 0.2f, 0.05f, 0.37f, 0.13f, 0.53f)
                reflectiveCurveToRelative(0.19f, 0.28f, 0.32f, 0.39f)
                reflectiveCurveToRelative(0.29f, 0.19f, 0.46f, 0.24f)
                reflectiveCurveToRelative(0.35f, 0.08f, 0.53f, 0.08f)
                curveToRelative(0.24f, 0.0f, 0.46f, -0.04f, 0.64f, -0.12f)
                reflectiveCurveToRelative(0.33f, -0.18f, 0.45f, -0.31f)
                reflectiveCurveToRelative(0.21f, -0.28f, 0.27f, -0.45f)
                reflectiveCurveToRelative(0.09f, -0.35f, 0.09f, -0.54f)
                curveToRelative(0.0f, -0.22f, -0.03f, -0.43f, -0.09f, -0.6f)
                reflectiveCurveToRelative(-0.14f, -0.33f, -0.25f, -0.45f)
                reflectiveCurveToRelative(-0.25f, -0.22f, -0.41f, -0.28f)
                reflectiveCurveToRelative(-0.34f, -0.1f, -0.55f, -0.1f)
                curveToRelative(-0.07f, 0.0f, -0.14f, 0.01f, -0.2f, 0.02f)
                reflectiveCurveToRelative(-0.13f, 0.02f, -0.18f, 0.04f)
                reflectiveCurveToRelative(-0.1f, 0.03f, -0.15f, 0.05f)
                reflectiveCurveToRelative(-0.08f, 0.04f, -0.11f, 0.05f)
                lineToRelative(0.11f, -0.92f)
                horizontalLineToRelative(1.7f)
                verticalLineToRelative(-0.71f)
                lineTo(10.9f, 11.74f)
                lineToRelative(-0.25f, 2.17f)
                lineToRelative(0.67f, 0.17f)
                curveToRelative(0.03f, -0.03f, 0.06f, -0.06f, 0.1f, -0.09f)
                reflectiveCurveToRelative(0.07f, -0.05f, 0.12f, -0.07f)
                reflectiveCurveToRelative(0.1f, -0.04f, 0.15f, -0.05f)
                reflectiveCurveToRelative(0.13f, -0.02f, 0.2f, -0.02f)
                curveToRelative(0.12f, 0.0f, 0.22f, 0.02f, 0.3f, 0.05f)
                reflectiveCurveToRelative(0.16f, 0.09f, 0.21f, 0.15f)
                reflectiveCurveToRelative(0.1f, 0.14f, 0.13f, 0.24f)
                reflectiveCurveToRelative(0.04f, 0.19f, 0.04f, 0.31f)
                reflectiveCurveToRelative(-0.01f, 0.22f, -0.03f, 0.31f)
                reflectiveCurveToRelative(-0.06f, 0.17f, -0.11f, 0.24f)
                close()
            }
        }
        return _forward5!!
    }

private var _forward5: ImageVector? = null
