/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Outlined.Motorcycle: ImageVector
    get() {
        if (_motorcycle != null) {
            return _motorcycle!!
        }
        _motorcycle = materialIcon(name = "Outlined.Motorcycle") {
            materialPath {
                moveTo(12.72f, 11.0f)
                lineToRelative(-2.0f, 2.0f)
                horizontalLineToRelative(-0.77f)
                lineToRelative(-0.25f, -0.69f)
                curveToRelative(-0.18f, -0.48f, -0.42f, -0.92f, -0.72f, -1.31f)
                horizontalLineToRelative(3.74f)
                moveToRelative(2.69f, -6.0f)
                horizontalLineTo(11.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(3.59f)
                lineToRelative(2.0f, 2.0f)
                horizontalLineTo(5.0f)
                curveToRelative(-2.8f, 0.0f, -5.0f, 2.2f, -5.0f, 5.0f)
                reflectiveCurveToRelative(2.2f, 5.0f, 5.0f, 5.0f)
                curveToRelative(2.46f, 0.0f, 4.45f, -1.69f, 4.9f, -4.0f)
                horizontalLineToRelative(1.65f)
                lineToRelative(2.77f, -2.77f)
                curveToRelative(-0.21f, 0.54f, -0.32f, 1.14f, -0.32f, 1.77f)
                curveToRelative(0.0f, 2.8f, 2.2f, 5.0f, 5.0f, 5.0f)
                reflectiveCurveToRelative(5.0f, -2.2f, 5.0f, -5.0f)
                curveToRelative(0.0f, -2.65f, -1.97f, -4.77f, -4.56f, -4.97f)
                lineTo(15.41f, 5.0f)
                close()
                moveTo(19.0f, 17.0f)
                curveToRelative(-1.66f, 0.0f, -3.0f, -1.34f, -3.0f, -3.0f)
                reflectiveCurveToRelative(1.34f, -3.0f, 3.0f, -3.0f)
                reflectiveCurveToRelative(3.0f, 1.34f, 3.0f, 3.0f)
                reflectiveCurveToRelative(-1.34f, 3.0f, -3.0f, 3.0f)
                close()
                moveTo(5.0f, 17.0f)
                curveToRelative(-1.63f, 0.0f, -3.0f, -1.37f, -3.0f, -3.0f)
                reflectiveCurveToRelative(1.37f, -3.0f, 3.0f, -3.0f)
                curveToRelative(1.28f, 0.0f, 2.4f, 0.85f, 2.82f, 2.0f)
                horizontalLineTo(5.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(2.82f)
                curveTo(7.4f, 16.15f, 6.28f, 17.0f, 5.0f, 17.0f)
                close()
            }
        }
        return _motorcycle!!
    }

private var _motorcycle: ImageVector? = null
