/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Outlined.Phishing: ImageVector
    get() {
        if (_phishing != null) {
            return _phishing!!
        }
        _phishing = materialIcon(name = "Outlined.Phishing") {
            materialPath {
                moveTo(17.0f, 6.18f)
                verticalLineTo(2.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineToRelative(4.18f)
                curveTo(13.84f, 6.6f, 13.0f, 7.7f, 13.0f, 9.0f)
                reflectiveCurveToRelative(0.84f, 2.4f, 2.0f, 2.82f)
                verticalLineTo(15.0f)
                curveToRelative(0.0f, 2.21f, -1.79f, 4.0f, -4.0f, 4.0f)
                reflectiveCurveToRelative(-4.0f, -1.79f, -4.0f, -4.0f)
                verticalLineToRelative(-1.17f)
                lineToRelative(1.59f, 1.59f)
                lineTo(10.0f, 14.0f)
                lineTo(5.0f, 9.0f)
                verticalLineToRelative(6.0f)
                curveToRelative(0.0f, 3.31f, 2.69f, 6.0f, 6.0f, 6.0f)
                reflectiveCurveToRelative(6.0f, -2.69f, 6.0f, -6.0f)
                verticalLineToRelative(-3.18f)
                curveToRelative(1.16f, -0.41f, 2.0f, -1.51f, 2.0f, -2.82f)
                reflectiveCurveTo(18.16f, 6.6f, 17.0f, 6.18f)
                close()
                moveTo(16.0f, 10.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, -0.45f, -1.0f, -1.0f)
                reflectiveCurveToRelative(0.45f, -1.0f, 1.0f, -1.0f)
                reflectiveCurveToRelative(1.0f, 0.45f, 1.0f, 1.0f)
                reflectiveCurveTo(16.55f, 10.0f, 16.0f, 10.0f)
                close()
            }
        }
        return _phishing!!
    }

private var _phishing: ImageVector? = null
