/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.Drafts: ImageVector
    get() {
        if (_drafts != null) {
            return _drafts!!
        }
        _drafts = materialIcon(name = "Sharp.Drafts") {
            materialPath {
                moveTo(21.99f, 6.86f)
                lineTo(12.0f, 1.0f)
                lineTo(2.0f, 6.86f)
                verticalLineTo(20.0f)
                horizontalLineToRelative(20.0f)
                lineToRelative(-0.01f, -13.14f)
                close()
                moveTo(12.0f, 13.0f)
                lineTo(3.74f, 7.84f)
                lineTo(12.0f, 3.0f)
                lineToRelative(8.26f, 4.84f)
                lineTo(12.0f, 13.0f)
                close()
            }
        }
        return _drafts!!
    }

private var _drafts: ImageVector? = null
