/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.SurroundSound: ImageVector
    get() {
        if (_surroundSound != null) {
            return _surroundSound!!
        }
        _surroundSound = materialIcon(name = "TwoTone.SurroundSound") {
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(4.0f, 18.0f)
                horizontalLineToRelative(16.0f)
                verticalLineTo(6.0f)
                horizontalLineTo(4.0f)
                verticalLineTo(18.0f)
                close()
                moveTo(16.94f, 7.06f)
                curveTo(18.32f, 8.41f, 19.0f, 10.21f, 19.0f, 12.0f)
                reflectiveCurveToRelative(-0.68f, 3.59f, -2.05f, 4.95f)
                lineToRelative(-1.23f, -1.23f)
                curveToRelative(1.02f, -1.03f, 1.53f, -2.37f, 1.53f, -3.72f)
                curveToRelative(0.0f, -1.35f, -0.52f, -2.69f, -1.54f, -3.71f)
                lineTo(16.94f, 7.06f)
                close()
                moveTo(12.0f, 8.5f)
                curveToRelative(1.93f, 0.0f, 3.5f, 1.57f, 3.5f, 3.5f)
                curveToRelative(0.0f, 1.93f, -1.57f, 3.5f, -3.5f, 3.5f)
                curveToRelative(-1.93f, 0.0f, -3.5f, -1.57f, -3.5f, -3.5f)
                curveTo(8.5f, 10.07f, 10.07f, 8.5f, 12.0f, 8.5f)
                close()
                moveTo(7.05f, 7.05f)
                lineToRelative(1.23f, 1.23f)
                curveTo(7.27f, 9.31f, 6.75f, 10.65f, 6.75f, 12.0f)
                curveToRelative(0.0f, 1.35f, 0.52f, 2.69f, 1.54f, 3.71f)
                lineToRelative(-1.23f, 1.23f)
                curveTo(5.68f, 15.59f, 5.0f, 13.79f, 5.0f, 12.0f)
                reflectiveCurveTo(5.68f, 8.41f, 7.05f, 7.05f)
                close()
            }
            materialPath {
                moveTo(20.0f, 4.0f)
                horizontalLineTo(4.0f)
                curveTo(2.9f, 4.0f, 2.0f, 4.9f, 2.0f, 6.0f)
                verticalLineToRelative(12.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(16.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                verticalLineTo(6.0f)
                curveTo(22.0f, 4.9f, 21.1f, 4.0f, 20.0f, 4.0f)
                close()
                moveTo(20.0f, 18.0f)
                horizontalLineTo(4.0f)
                verticalLineTo(6.0f)
                horizontalLineToRelative(16.0f)
                verticalLineTo(18.0f)
                close()
            }
            materialPath {
                moveTo(8.29f, 15.71f)
                curveTo(7.27f, 14.69f, 6.75f, 13.35f, 6.75f, 12.0f)
                curveToRelative(0.0f, -1.35f, 0.52f, -2.69f, 1.53f, -3.72f)
                lineTo(7.05f, 7.05f)
                curveTo(5.68f, 8.41f, 5.0f, 10.21f, 5.0f, 12.0f)
                reflectiveCurveToRelative(0.68f, 3.59f, 2.06f, 4.94f)
                lineTo(8.29f, 15.71f)
                close()
            }
            materialPath {
                moveTo(12.0f, 15.5f)
                curveToRelative(1.93f, 0.0f, 3.5f, -1.57f, 3.5f, -3.5f)
                curveToRelative(0.0f, -1.93f, -1.57f, -3.5f, -3.5f, -3.5f)
                curveToRelative(-1.93f, 0.0f, -3.5f, 1.57f, -3.5f, 3.5f)
                curveTo(8.5f, 13.93f, 10.07f, 15.5f, 12.0f, 15.5f)
                close()
                moveTo(12.0f, 10.5f)
                curveToRelative(0.83f, 0.0f, 1.5f, 0.67f, 1.5f, 1.5f)
                reflectiveCurveToRelative(-0.67f, 1.5f, -1.5f, 1.5f)
                reflectiveCurveToRelative(-1.5f, -0.67f, -1.5f, -1.5f)
                reflectiveCurveTo(11.17f, 10.5f, 12.0f, 10.5f)
                close()
            }
            materialPath {
                moveTo(15.72f, 15.72f)
                lineToRelative(1.23f, 1.23f)
                curveTo(18.32f, 15.59f, 19.0f, 13.79f, 19.0f, 12.0f)
                reflectiveCurveToRelative(-0.68f, -3.59f, -2.06f, -4.94f)
                lineToRelative(-1.23f, 1.23f)
                curveToRelative(1.02f, 1.02f, 1.54f, 2.36f, 1.54f, 3.71f)
                curveTo(17.25f, 13.35f, 16.73f, 14.69f, 15.72f, 15.72f)
                close()
            }
        }
        return _surroundSound!!
    }

private var _surroundSound: ImageVector? = null
