/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.Bungalow: ImageVector
    get() {
        if (_bungalow != null) {
            return _bungalow!!
        }
        _bungalow = materialIcon(name = "Rounded.Bungalow") {
            materialPath {
                moveTo(12.0f, 16.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, 0.45f, 1.0f, 1.0f)
                verticalLineToRelative(4.0f)
                horizontalLineToRelative(3.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, -0.45f, 1.0f, -1.0f)
                verticalLineToRelative(-5.21f)
                lineToRelative(0.57f, 0.92f)
                curveToRelative(0.29f, 0.47f, 0.91f, 0.61f, 1.38f, 0.32f)
                curveToRelative(0.47f, -0.29f, 0.61f, -0.91f, 0.32f, -1.38f)
                lineTo(12.85f, 4.36f)
                curveToRelative(-0.39f, -0.63f, -1.31f, -0.63f, -1.7f, 0.0f)
                lineTo(4.73f, 14.65f)
                curveToRelative(-0.29f, 0.47f, -0.15f, 1.09f, 0.32f, 1.38f)
                curveToRelative(0.47f, 0.29f, 1.08f, 0.15f, 1.38f, -0.32f)
                lineTo(7.0f, 14.8f)
                verticalLineTo(20.0f)
                curveToRelative(0.0f, 0.55f, 0.45f, 1.0f, 1.0f, 1.0f)
                horizontalLineToRelative(3.0f)
                verticalLineToRelative(-4.0f)
                curveTo(11.0f, 16.45f, 11.45f, 16.0f, 12.0f, 16.0f)
                close()
                moveTo(13.0f, 13.0f)
                curveToRelative(0.0f, 0.55f, -0.45f, 1.0f, -1.0f, 1.0f)
                reflectiveCurveToRelative(-1.0f, -0.45f, -1.0f, -1.0f)
                reflectiveCurveToRelative(0.45f, -1.0f, 1.0f, -1.0f)
                reflectiveCurveTo(13.0f, 12.45f, 13.0f, 13.0f)
                close()
            }
        }
        return _bungalow!!
    }

private var _bungalow: ImageVector? = null
